/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client;

import com.nimbusds.jose.jwk.JWK;
import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.domain.model.cases.Cases;
import dev.fitko.fitconnect.api.domain.model.event.EventLogEntry;
import dev.fitko.fitconnect.api.domain.model.event.Status;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.reply.RepliesForPickup;
import dev.fitko.fitconnect.api.domain.model.submission.SentSubmission;
import dev.fitko.fitconnect.api.domain.sender.ReceivedReply;
import dev.fitko.fitconnect.api.domain.sender.SendableEncryptedSubmission;
import dev.fitko.fitconnect.api.domain.sender.SendableSubmission;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectSenderException;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectSubscriberException;
import dev.fitko.fitconnect.client.attachments.AttachmentStorageResolver;
import dev.fitko.fitconnect.client.sender.ReplyReceiver;
import dev.fitko.fitconnect.client.sender.SubmissionSender;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public class SenderClient {
    private static final int DEFAULT_CASE_LIMIT = 500;
    private static final int DEFAULT_REPLY_LIMIT = 500;
    private final FitConnectService fitConnectService;
    private final ReplyReceiver replyReceiver;
    private final AttachmentStorageResolver attachmentStorageResolver;
    private final SubmissionSender submissionSender;

    public SenderClient(FitConnectService fitConnectService, SubmissionSender submissionSender, ReplyReceiver replyReceiver, AttachmentStorageResolver attachmentStorageResolver) {
        this.fitConnectService = fitConnectService;
        this.submissionSender = submissionSender;
        this.replyReceiver = replyReceiver;
        this.attachmentStorageResolver = attachmentStorageResolver;
    }

    public String getPublicKeyForDestination(UUID destinationId) throws FitConnectSenderException {
        return this.wrapExceptions(() -> this.fitConnectService.getEncryptionKeyForDestination(destinationId).toJSONString(), "Retrieving public key failed.");
    }

    public Status getSubmissionStatus(SentSubmission sentSubmission) throws FitConnectSenderException {
        return this.wrapExceptions(() -> this.fitConnectService.getStatus(sentSubmission), "Retrieving current status of submission failed.");
    }

    public List<EventLogEntry> getEventLogForSubmission(SentSubmission sentSubmission) {
        UUID destinationId = sentSubmission.getDestinationId();
        UUID caseId = sentSubmission.getCaseId();
        UUID submissionId = sentSubmission.getSubmissionId();
        AuthenticationTags authTags = sentSubmission.getAuthenticationTags();
        return this.fitConnectService.getEventLogForSubmission(destinationId, caseId, submissionId, authTags);
    }

    public List<EventLogEntry> getEventLogForCase(UUID destinationId, UUID caseId) {
        return this.fitConnectService.getEventLogForCase(destinationId, caseId, null);
    }

    public ValidationResult validateCallback(String hmac, Long timestampInSec, String httpBody, String callbackSecret) throws FitConnectSenderException {
        return this.wrapExceptions(() -> this.fitConnectService.validateCallback(hmac, timestampInSec, httpBody, callbackSecret), "Callback validation could not be applied.");
    }

    public SentSubmission send(SendableSubmission sendableSubmission) throws FitConnectSenderException {
        return this.wrapExceptions(() -> this.submissionSender.sendSubmission(sendableSubmission), "Sending submission failed.");
    }

    public SentSubmission send(SendableEncryptedSubmission sendableEncryptedSubmission) throws FitConnectSenderException {
        return this.wrapExceptions(() -> this.submissionSender.sendEncryptedSubmission(sendableEncryptedSubmission), "Sending already encrypted submission failed.");
    }

    public ReceivedReply getReply(UUID replyId, JWK privateReplyDecryptionKey) {
        return this.wrapExceptions(() -> this.replyReceiver.receiveReply(replyId, privateReplyDecryptionKey.toRSAKey()), "Loading reply failed.");
    }

    public void rejectReply(UUID replyId, List<Problem> rejectionProblems) throws FitConnectSubscriberException {
        this.wrapExceptions(() -> {
            this.fitConnectService.rejectReply(replyId, rejectionProblems);
            return null;
        }, "Could not reject reply");
    }

    public Cases listCases() throws FitConnectSenderException {
        return this.listCases(0, 500);
    }

    public Cases listCases(int limit, int offset) throws FitConnectSenderException {
        return this.wrapExceptions(() -> this.fitConnectService.listCases(limit, offset), "Loading active cases failed.");
    }

    public RepliesForPickup getAvailableReplies() {
        return this.wrapExceptions(() -> this.fitConnectService.getAvailableReplies(500, 0), "Loading replies failed");
    }

    public RepliesForPickup getAvailableReplies(int limit, int offset) {
        return this.wrapExceptions(() -> this.fitConnectService.getAvailableReplies(limit, offset), "Loading replies failed");
    }

    public void clearAttachmentStorage() {
        this.wrapExceptions(() -> {
            this.attachmentStorageResolver.clearBasePathContents();
            return null;
        }, "Clearing attachment storage directory failed");
    }

    private <T> T wrapExceptions(Supplier<T> supplier, String errorMessage) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new FitConnectSenderException(Optional.ofNullable(e.getMessage()).orElse(errorMessage), Optional.ofNullable(e.getCause()).orElse(e));
        }
    }
}

