/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client;

import dev.fitko.fitconnect.api.domain.model.route.Area;
import dev.fitko.fitconnect.api.domain.model.route.Route;
import dev.fitko.fitconnect.api.domain.model.route.RouteResult;
import dev.fitko.fitconnect.api.domain.routing.DestinationSearch;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectRouterException;
import dev.fitko.fitconnect.api.services.routing.RoutingService;
import dev.fitko.fitconnect.core.routing.RouteVerifier;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public final class RouterClient {
    private final RoutingService routingService;
    private final RouteVerifier routeVerifier;

    public RouterClient(RoutingService routingService, RouteVerifier routeVerifier) {
        this.routingService = routingService;
        this.routeVerifier = routeVerifier;
    }

    public List<Route> findDestinations(DestinationSearch search) throws FitConnectRouterException {
        String leikaKey = search.getLeikaKey();
        String ars = search.getArs();
        String ags = search.getAgs();
        String areaId = search.getAreaId();
        int offset = search.getOffset();
        int limit = search.getLimit();
        RouteResult routeResult = this.wrapExceptions(() -> this.routingService.getRoutes(leikaKey, ars, ags, areaId, offset, limit), "Finding destination failed");
        return this.routeVerifier.validateRouteDestinations(routeResult.getRoutes(), leikaKey, ars);
    }

    public List<Area> findAreas(String filter, int offset, int limit) throws FitConnectRouterException {
        return this.wrapExceptions(() -> this.findAreas(List.of(filter), offset, limit), "Finding areas failed");
    }

    public List<Area> findAreas(List<String> filters, int offset, int limit) throws FitConnectRouterException {
        return this.wrapExceptions(() -> this.routingService.getAreas(filters, offset, limit).getAreas(), "Finding areas failed");
    }

    private <T> T wrapExceptions(Supplier<T> supplier, String errorMessage) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new FitConnectRouterException(Optional.ofNullable(e.getMessage()).orElse(errorMessage), Optional.ofNullable(e.getCause()).orElse(e));
        }
    }
}

