/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.client;

import dev.fitko.fitconnect.api.domain.limits.Limit;
import dev.fitko.fitconnect.api.domain.limits.destination.ChangeRequestStatus;
import dev.fitko.fitconnect.api.domain.limits.destination.DestinationLimits;
import dev.fitko.fitconnect.api.domain.limits.destination.LimitChangeRequest;
import dev.fitko.fitconnect.api.domain.model.destination.CreateDestination;
import dev.fitko.fitconnect.api.domain.model.destination.Destination;
import dev.fitko.fitconnect.api.domain.model.destination.Destinations;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwk;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwks;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectDestinationException;
import dev.fitko.fitconnect.api.services.destination.DestinationService;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DestinationClient.class);
    private final DestinationService destinationService;

    public DestinationClient(DestinationService destinationService) {
        this.destinationService = destinationService;
    }

    public Destination getDestination(UUID destinationId) {
        LOGGER.info("Getting destination {}", (Object)destinationId);
        return this.wrapExceptions(() -> this.destinationService.getDestination(destinationId), "Getting destination failed");
    }

    public Destination createDestination(CreateDestination destination) {
        LOGGER.info("Creating new destination");
        return this.wrapExceptions(() -> this.destinationService.createDestination(destination), "Creating new destination failed");
    }

    public Destination updateDestination(Destination destination) {
        LOGGER.info("Updating destination {}", (Object)destination.getDestinationId());
        return this.wrapExceptions(() -> this.destinationService.updateDestination(destination), "Updating destination failed");
    }

    public Destinations listDestinations(int offset, int limit) {
        LOGGER.info("Listing available destinations");
        return this.wrapExceptions(() -> this.destinationService.listDestinations(offset, limit), "Listing destinations failed");
    }

    public void deleteDestination(UUID destinationId) {
        LOGGER.info("Deleting destination {}", (Object)destinationId);
        this.wrapExceptions(() -> {
            this.destinationService.deleteDestination(destinationId);
            return null;
        }, "Deleting destination failed");
    }

    public ApiJwk getKeyForDestination(UUID destinationId, String keyId) {
        LOGGER.info("Loading key {} for destination {}", (Object)keyId, (Object)destinationId);
        return this.wrapExceptions(() -> this.destinationService.getKey(destinationId, keyId), "Loading key failed");
    }

    public ApiJwks getKeysForDestination(UUID destinationId, int offset, int limit) {
        LOGGER.info("Loading available keys for destination {}", (Object)destinationId);
        return this.wrapExceptions(() -> this.destinationService.listKeys(destinationId, offset, limit), "Loading keys failed");
    }

    public void addKeyToDestination(UUID destinationId, ApiJwk publicKey) {
        LOGGER.info("Adding key {} to destination {}", (Object)publicKey.getKid(), (Object)destinationId);
        this.wrapExceptions(() -> {
            this.destinationService.addKey(destinationId, publicKey);
            return null;
        }, "Adding new key to destination failed");
    }

    public DestinationLimits getAttachmentLimits(UUID destinationId) {
        LOGGER.info("Loading attachment limits for destination {}", (Object)destinationId);
        return this.wrapExceptions(() -> this.destinationService.getAttachmentLimits(destinationId), "Loading attachment limits failed");
    }

    public DestinationLimits requestLimitChange(UUID destinationId, Limit limitValues, String requestReason, String contactEmail) {
        LOGGER.info("Requesting limit change for destination {}", (Object)destinationId);
        LimitChangeRequest request = LimitChangeRequest.builder().status(ChangeRequestStatus.PENDING).requestReason(requestReason).contactEmail(contactEmail).values(limitValues).build();
        return this.wrapExceptions(() -> this.destinationService.requestLimitChange(destinationId, request), "Requesting limit change failed");
    }

    public DestinationLimits requestLimitChange(UUID destinationId, Limit limitValues, String requestReason) {
        return this.requestLimitChange(destinationId, limitValues, requestReason, null);
    }

    public DestinationLimits withdrawLimitChangeRequest(UUID destinationId) {
        LOGGER.info("Withdrawing current limit change request for destination {}", (Object)destinationId);
        LimitChangeRequest request = LimitChangeRequest.builder().status(ChangeRequestStatus.WITHDRAWN).build();
        return this.wrapExceptions(() -> this.destinationService.requestLimitChange(destinationId, request), "Withdrawing change request failed");
    }

    private <T> T wrapExceptions(Supplier<T> supplier, String errorMessage) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            throw new FitConnectDestinationException(Optional.ofNullable(e.getMessage()).orElse(errorMessage), Optional.ofNullable(e.getCause()).orElse(e));
        }
    }
}

