/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.exceptions.internal;

public class RestApiException
extends RuntimeException {
    private int statusCode = 500;

    public RestApiException(String errorMessage, Throwable error) {
        super(errorMessage, error);
    }

    public RestApiException(String errorMessage, Throwable error, int statusCode) {
        super(errorMessage, error);
        this.statusCode = statusCode;
    }

    public RestApiException(String errorMessage) {
        super(errorMessage);
    }

    public RestApiException(String errorMessage, int statusCode) {
        super(errorMessage);
        this.statusCode = statusCode;
    }

    public RestApiException fromRootCause(Throwable throwable) {
        return new RestApiException(throwable.getMessage(), throwable, this.statusCode);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public boolean isNotFound() {
        return this.statusCode == 404;
    }

    public boolean isStatusCodeSuccessful() {
        return this.statusCode >= 200 && this.statusCode <= 226;
    }

    public boolean isClientError() {
        return this.statusCode >= 400 && this.statusCode < 500;
    }

    public boolean isServerError() {
        return this.statusCode >= 500;
    }
}

