/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.zbp;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import lombok.Generated;

public final class AuthorKeyPair {
    private final RSAKey authorPrivateKey;
    private final String authorCertificateAsPem;

    private AuthorKeyPair(RSAKey authorPrivateKey, String authorCertificateAsPem) {
        this.authorPrivateKey = authorPrivateKey;
        this.authorCertificateAsPem = authorCertificateAsPem;
    }

    public static AuthorKeyPairBuilder builder() {
        return new AuthorKeyPairBuilder();
    }

    @Generated
    public RSAKey getAuthorPrivateKey() {
        return this.authorPrivateKey;
    }

    @Generated
    public String getAuthorCertificateAsPem() {
        return this.authorCertificateAsPem;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorKeyPair)) {
            return false;
        }
        AuthorKeyPair other = (AuthorKeyPair)o;
        RSAKey this$authorPrivateKey = this.getAuthorPrivateKey();
        RSAKey other$authorPrivateKey = other.getAuthorPrivateKey();
        if (this$authorPrivateKey == null ? other$authorPrivateKey != null : !this$authorPrivateKey.equals(other$authorPrivateKey)) {
            return false;
        }
        String this$authorCertificateAsPem = this.getAuthorCertificateAsPem();
        String other$authorCertificateAsPem = other.getAuthorCertificateAsPem();
        return !(this$authorCertificateAsPem == null ? other$authorCertificateAsPem != null : !this$authorCertificateAsPem.equals(other$authorCertificateAsPem));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RSAKey $authorPrivateKey = this.getAuthorPrivateKey();
        result = result * 59 + ($authorPrivateKey == null ? 43 : $authorPrivateKey.hashCode());
        String $authorCertificateAsPem = this.getAuthorCertificateAsPem();
        result = result * 59 + ($authorCertificateAsPem == null ? 43 : $authorCertificateAsPem.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthorKeyPair(authorPrivateKey=" + String.valueOf(this.getAuthorPrivateKey()) + ", authorCertificateAsPem=" + this.getAuthorCertificateAsPem() + ")";
    }

    public static class AuthorKeyPairBuilder {
        private String authorCertificateAsPem;
        private RSAKey authorPrivateKey;

        AuthorKeyPairBuilder() {
        }

        public AuthorKeyPairBuilder authorCertificatePath(Path authorCertificatePath) {
            this.authorCertificateAsPem = this.getPemFromPath(authorCertificatePath);
            return this;
        }

        public AuthorKeyPairBuilder authorCertificateAsPem(String authorCertificateAsPem) {
            this.getKeyFromPemString(authorCertificateAsPem);
            this.authorCertificateAsPem = authorCertificateAsPem;
            return this;
        }

        public AuthorKeyPairBuilder authorPrivateKeyPath(Path authorPrivateKeyPath) {
            this.authorPrivateKey = this.getKeyFromPath(authorPrivateKeyPath);
            return this;
        }

        public AuthorKeyPairBuilder authorPrivateKeyAsPem(String authorPrivateKeyAsPem) {
            this.authorPrivateKey = this.getKeyFromPemString(authorPrivateKeyAsPem);
            return this;
        }

        public AuthorKeyPairBuilder authorPrivateKey(RSAKey authorPrivateKey) {
            this.authorPrivateKey = authorPrivateKey;
            return this;
        }

        public AuthorKeyPair build() {
            return new AuthorKeyPair(this.authorPrivateKey, this.authorCertificateAsPem);
        }

        private RSAKey getKeyFromPath(Path path) {
            try {
                String pemObject = Files.readString(path);
                return this.getKeyFromPemString(pemObject);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed reading path to PEM", e);
            }
        }

        private String getPemFromPath(Path path) {
            try {
                String pemObject = Files.readString(path);
                this.getKeyFromPemString(pemObject);
                return pemObject;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed reading PEM", e);
            }
        }

        private RSAKey getKeyFromPemString(String pemObject) {
            try {
                return JWK.parseFromPEMEncodedObjects((String)pemObject).toRSAKey();
            }
            catch (JOSEException e) {
                throw new RuntimeException("Failed parsing PEM", e);
            }
        }
    }
}

