/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.validation;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.exceptions.internal.ValidationException;
import java.util.ArrayList;
import java.util.List;

public final class ValidationResult {
    private final boolean isValid;
    private final Exception error;
    private final List<Problem> validationProblems = new ArrayList<Problem>();

    private ValidationResult(boolean isValid) {
        this.isValid = isValid;
        this.error = null;
    }

    private ValidationResult(boolean isValid, Exception error) {
        this.isValid = isValid;
        this.error = error;
    }

    private ValidationResult(Problem problem) {
        this.isValid = false;
        this.error = null;
        this.validationProblems.add(problem);
    }

    private ValidationResult(List<Problem> problems) {
        this.isValid = false;
        this.error = null;
        this.validationProblems.addAll(problems);
    }

    private ValidationResult(Exception error, Problem problem) {
        this.isValid = false;
        this.error = error;
        this.validationProblems.add(problem);
    }

    public static ValidationResult ok() {
        return new ValidationResult(true);
    }

    public static ValidationResult error(Exception exception) {
        return new ValidationResult(false, exception);
    }

    public static ValidationResult error(String errorMessage) {
        return new ValidationResult(false, new ValidationException(errorMessage));
    }

    public static ValidationResult problem(Problem problem) {
        return new ValidationResult(problem);
    }

    public static ValidationResult problems(List<Problem> problems) {
        return new ValidationResult(problems);
    }

    public static ValidationResult withErrorAndProblem(Exception exception, Problem problem) {
        return new ValidationResult(exception, problem);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean hasProblems() {
        return !this.validationProblems.isEmpty();
    }

    public List<Problem> getProblems() {
        return this.validationProblems;
    }

    public Exception getError() {
        return this.error;
    }
}

