/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.validation;

import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.exceptions.internal.ValidationException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public class ValidationContext {
    private final List<ValidationResult> validationResults;
    private final UUID destinationId;
    private final UUID caseId;
    private final AuthenticationTags authenticationTags;
    private final boolean validateAuthTags;

    private ValidationContext(UUID destinationId, UUID caseId, boolean validateAuthTags, AuthenticationTags authenticationTags) {
        this.destinationId = destinationId;
        this.caseId = caseId;
        this.authenticationTags = authenticationTags;
        this.validationResults = new ArrayList<ValidationResult>();
        this.validateAuthTags = validateAuthTags;
    }

    public static ValidationContext withAuthTagValidation(UUID destinationId, UUID caseId, AuthenticationTags authenticationTags) {
        return new ValidationContext(destinationId, caseId, true, authenticationTags);
    }

    public static ValidationContext withoutAuthTagValidation(UUID destinationId, UUID caseId) {
        return new ValidationContext(destinationId, caseId, false, null);
    }

    public static ValidationContext withoutAuthTagValidation(UUID caseId) {
        return new ValidationContext(null, caseId, false, null);
    }

    public void addResult(ValidationResult validationResult) {
        if (validationResult.hasError()) {
            this.validationResults.add(validationResult);
        }
    }

    public void addErrorIfTestFailed(boolean test, String message) {
        if (!test) {
            this.addResult(ValidationResult.error(new ValidationException(message)));
        }
    }

    public void addError(String message) {
        this.addResult(ValidationResult.error(new ValidationException(message)));
    }

    public void addError(Exception exception) {
        this.addResult(ValidationResult.error(new ValidationException(exception.getMessage(), exception)));
    }

    public UUID getDestinationId() {
        return this.destinationId;
    }

    public UUID getCaseId() {
        return this.caseId;
    }

    public AuthenticationTags getAuthenticationTags() {
        return this.authenticationTags;
    }

    public boolean validateAuthTags() {
        return this.validateAuthTags;
    }

    @Generated
    public List<ValidationResult> getValidationResults() {
        return this.validationResults;
    }

    @Generated
    public boolean isValidateAuthTags() {
        return this.validateAuthTags;
    }
}

