/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.subscriber;

import com.nimbusds.jose.jwk.JWK;
import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.metadata.data.MimeType;
import dev.fitko.fitconnect.api.domain.subscriber.steps.BuildReplyStep;
import dev.fitko.fitconnect.api.domain.subscriber.steps.OptionalReplyPropertiesStep;
import dev.fitko.fitconnect.api.domain.subscriber.steps.ReplyDataStep;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public final class SendableReply {
    private final UUID caseId;
    private final byte[] data;
    private final URI schemaUri;
    private final MimeType dataMimeType;
    private final List<Attachment> attachments;
    private final JWK replyEncryptionKey;

    private SendableReply(Builder builder) {
        this.caseId = builder.getCaseId();
        this.data = builder.getData();
        this.schemaUri = builder.getSchemaUri();
        this.dataMimeType = builder.getDataMimeType();
        this.attachments = Collections.unmodifiableList(builder.getAttachments());
        this.replyEncryptionKey = builder.getReplyEncryptionKey();
    }

    public static ReplyDataStep forCase(UUID caseId) {
        return new Builder(caseId);
    }

    @Generated
    public UUID getCaseId() {
        return this.caseId;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public URI getSchemaUri() {
        return this.schemaUri;
    }

    @Generated
    public MimeType getDataMimeType() {
        return this.dataMimeType;
    }

    @Generated
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Generated
    public JWK getReplyEncryptionKey() {
        return this.replyEncryptionKey;
    }

    private static final class Builder
    implements ReplyDataStep,
    OptionalReplyPropertiesStep,
    BuildReplyStep {
        private final UUID caseId;
        private final List<Attachment> attachments = new ArrayList<Attachment>();
        private byte[] data;
        private URI schemaUri;
        private MimeType dataMimeType;
        private JWK replyEncryptionKey;
        private static final byte[] EMPTY_DATA = new byte[0];

        public Builder(UUID caseId) {
            this.caseId = caseId;
        }

        @Override
        public OptionalReplyPropertiesStep setJsonData(String replyData, URI replyDataSchemaUri) {
            this.setJsonData(replyData.getBytes(StandardCharsets.UTF_8), replyDataSchemaUri);
            return this;
        }

        @Override
        public OptionalReplyPropertiesStep setJsonData(byte[] data, URI schemaUri) {
            this.dataMimeType = MimeType.APPLICATION_JSON;
            this.data = this.getValidatedData(data);
            this.schemaUri = schemaUri;
            return this;
        }

        @Override
        public OptionalReplyPropertiesStep setXmlData(String replyData, URI replyDataSchemaUri) {
            this.setXmlData(replyData.getBytes(StandardCharsets.UTF_8), replyDataSchemaUri);
            return this;
        }

        @Override
        public OptionalReplyPropertiesStep setXmlData(byte[] data, URI schemaUri) {
            this.dataMimeType = MimeType.APPLICATION_XML;
            this.data = this.getValidatedData(data);
            this.schemaUri = schemaUri;
            return this;
        }

        @Override
        public ReplyDataStep setReplyEncryptionKey(JWK replyEncryptionKey) {
            this.replyEncryptionKey = replyEncryptionKey;
            return this;
        }

        @Override
        public OptionalReplyPropertiesStep addAttachments(List<Attachment> attachments) {
            if (attachments != null && !attachments.isEmpty()) {
                this.attachments.addAll(attachments);
            }
            return this;
        }

        @Override
        public OptionalReplyPropertiesStep addAttachment(Attachment attachment) {
            this.attachments.add(attachment);
            return this;
        }

        @Override
        public SendableReply build() {
            return new SendableReply(this);
        }

        private byte[] getValidatedData(byte[] data) {
            if (data.length > 0xD00000) {
                this.attachments.add(Attachment.fromSubmissionData(data, this.dataMimeType));
                return EMPTY_DATA;
            }
            return data;
        }

        @Generated
        public UUID getCaseId() {
            return this.caseId;
        }

        @Generated
        public List<Attachment> getAttachments() {
            return this.attachments;
        }

        @Generated
        public byte[] getData() {
            return this.data;
        }

        @Generated
        public URI getSchemaUri() {
            return this.schemaUri;
        }

        @Generated
        public MimeType getDataMimeType() {
            return this.dataMimeType;
        }

        @Generated
        public JWK getReplyEncryptionKey() {
            return this.replyEncryptionKey;
        }
    }
}

