/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.subscriber;

import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.event.EventPayload;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.submission.PublicService;
import dev.fitko.fitconnect.api.domain.subscriber.ReceivedSubmissionData;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectSubscriberException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivedSubmission
implements Comparable<ReceivedSubmission> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReceivedSubmission.class);
    private final FitConnectService subscriber;
    private final ReceivedSubmissionData receivedData;

    public ReceivedSubmission(FitConnectService subscriber, ReceivedSubmissionData receivedData) {
        this.subscriber = subscriber;
        this.receivedData = receivedData;
    }

    public void acceptSubmission(Problem ... problems) {
        try {
            this.subscriber.acceptSubmission(this.getEventPayload(problems));
        }
        catch (Exception e) {
            throw new FitConnectSubscriberException("Accepting submission failed", e.getCause() != null ? e.getCause() : e);
        }
    }

    public void rejectSubmission(List<Problem> rejectionProblems) {
        try {
            this.subscriber.rejectSubmission(EventPayload.forRejectEvent(this.receivedData.getSubmission(), rejectionProblems));
        }
        catch (Exception e) {
            throw new FitConnectSubscriberException("Rejecting submission failed", e.getCause() != null ? e.getCause() : e);
        }
    }

    public String getDataAsString() {
        return new String(this.receivedData.getData(), StandardCharsets.UTF_8);
    }

    public byte[] getDataAsBytes() {
        return this.receivedData.getData();
    }

    public String getDataMimeType() {
        return this.getMetadata().getContentStructure().getData().getSubmissionSchema().getMimeType().value();
    }

    public URI getDataSchemaUri() {
        return this.getMetadata().getContentStructure().getData().getSubmissionSchema().getSchemaUri();
    }

    public PublicService getServiceType() {
        return this.receivedData.getSubmission().getPublicService();
    }

    public Optional<String> getRegion() {
        return Optional.ofNullable(this.receivedData.getSubmission().getRegion());
    }

    public List<Attachment> getAttachments() {
        return this.receivedData.getAttachments();
    }

    public Metadata getMetadata() {
        return this.receivedData.getMetadata();
    }

    public Optional<LocalDate> getApplicationDate() {
        Metadata metadata = this.getMetadata();
        if (metadata == null || metadata.getAdditionalReferenceInfo() == null || metadata.getAdditionalReferenceInfo().getApplicationDate() == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(LocalDate.parse(metadata.getAdditionalReferenceInfo().getApplicationDate()));
        }
        catch (DateTimeParseException e) {
            LOGGER.error("Invalid application date format {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public UUID getCaseId() {
        return this.receivedData.getSubmission().getCaseId();
    }

    public UUID getDestinationId() {
        return this.receivedData.getSubmission().getDestinationId();
    }

    public UUID getSubmissionId() {
        return this.receivedData.getSubmission().getSubmissionId();
    }

    public Date getSubmittedAt() {
        return this.receivedData.getSubmissionStatus().getIssuedAt();
    }

    private EventPayload getEventPayload(Problem[] problems) {
        if (this.getAttachments().isEmpty()) {
            return EventPayload.forAcceptEvent(this.receivedData.getSubmission(), problems);
        }
        return EventPayload.forAcceptEventWithAttachments(this.receivedData.getSubmission(), this.receivedData.getAttachmentAuthTags(), problems);
    }

    @Override
    public int compareTo(ReceivedSubmission other) {
        return this.getSubmittedAt().compareTo(other.getSubmittedAt());
    }
}

