/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.sender;

import dev.fitko.fitconnect.api.config.defaults.MetadataVersion;
import dev.fitko.fitconnect.api.config.defaults.SchemaConfig;
import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.callback.Callback;
import dev.fitko.fitconnect.api.domain.model.metadata.AdditionalReferenceInfo;
import dev.fitko.fitconnect.api.domain.model.metadata.AuthenticationInformation;
import dev.fitko.fitconnect.api.domain.model.metadata.data.MimeType;
import dev.fitko.fitconnect.api.domain.model.metadata.data.SubmissionSchema;
import dev.fitko.fitconnect.api.domain.model.metadata.payment.PaymentInformation;
import dev.fitko.fitconnect.api.domain.model.metadata.v2.Author;
import dev.fitko.fitconnect.api.domain.model.metadata.v2.DataSet;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.ReplyChannel;
import dev.fitko.fitconnect.api.domain.model.submission.PublicService;
import dev.fitko.fitconnect.api.domain.sender.steps.unencrypted.BuildStep;
import dev.fitko.fitconnect.api.domain.sender.steps.unencrypted.DataStep;
import dev.fitko.fitconnect.api.domain.sender.steps.unencrypted.DestinationStep;
import dev.fitko.fitconnect.api.domain.sender.steps.unencrypted.OptionalPropertiesStep;
import dev.fitko.fitconnect.api.domain.sender.steps.unencrypted.ServiceTypeStep;
import dev.fitko.fitconnect.api.domain.zbp.AuthorKeyPair;
import dev.fitko.fitconnect.api.domain.zbp.message.CreateMessage;
import dev.fitko.fitconnect.api.domain.zbp.state.CreateState;
import dev.fitko.fitconnect.client.zbp.ZBPEnvelopeBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

public final class SendableSubmission {
    private final UUID destinationId;
    private final UUID caseId;
    private final byte[] data;
    private final SubmissionSchema submissionSchema;
    private final List<Attachment> attachments;
    private final PublicService serviceType;
    private final String serviceRegion;
    private final List<AuthenticationInformation> authenticationInformation;
    private final AdditionalReferenceInfo additionalReferenceInfo;
    private final PaymentInformation paymentInformation;
    private final ReplyChannel replyChannel;
    private final Callback callback;
    private final MetadataVersion metadataVersion;
    private final List<DataSet> dataSets;
    private final Author author;

    private SendableSubmission(Builder builder) {
        this.destinationId = builder.getDestinationId();
        this.caseId = builder.getCaseId();
        this.data = builder.getData();
        this.submissionSchema = new SubmissionSchema(builder.getSchemaUri(), builder.getDataMimeType());
        this.attachments = Collections.unmodifiableList(builder.getAttachments());
        this.serviceType = builder.getServiceType();
        this.serviceRegion = builder.getServiceRegion();
        this.authenticationInformation = builder.getAuthenticationInformation();
        this.replyChannel = builder.getReplyChannel();
        this.paymentInformation = builder.getPaymentInformation();
        this.callback = builder.getCallback();
        this.additionalReferenceInfo = builder.getAdditionalReferenceInfo();
        this.dataSets = builder.getDataSets();
        this.author = builder.getAuthor();
        this.metadataVersion = Optional.ofNullable(builder.getMetadataVersion()).orElse(MetadataVersion.V2);
    }

    public static DestinationStep Builder() {
        return new Builder();
    }

    @Generated
    public UUID getDestinationId() {
        return this.destinationId;
    }

    @Generated
    public UUID getCaseId() {
        return this.caseId;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public SubmissionSchema getSubmissionSchema() {
        return this.submissionSchema;
    }

    @Generated
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Generated
    public PublicService getServiceType() {
        return this.serviceType;
    }

    @Generated
    public String getServiceRegion() {
        return this.serviceRegion;
    }

    @Generated
    public List<AuthenticationInformation> getAuthenticationInformation() {
        return this.authenticationInformation;
    }

    @Generated
    public AdditionalReferenceInfo getAdditionalReferenceInfo() {
        return this.additionalReferenceInfo;
    }

    @Generated
    public PaymentInformation getPaymentInformation() {
        return this.paymentInformation;
    }

    @Generated
    public ReplyChannel getReplyChannel() {
        return this.replyChannel;
    }

    @Generated
    public Callback getCallback() {
        return this.callback;
    }

    @Generated
    public MetadataVersion getMetadataVersion() {
        return this.metadataVersion;
    }

    @Generated
    public List<DataSet> getDataSets() {
        return this.dataSets;
    }

    @Generated
    public Author getAuthor() {
        return this.author;
    }

    private static final class Builder
    implements DestinationStep,
    ServiceTypeStep,
    DataStep,
    OptionalPropertiesStep,
    BuildStep {
        private UUID destinationId;
        private UUID caseId;
        private final List<Attachment> attachments = new ArrayList<Attachment>();
        private byte[] data;
        private URI schemaUri;
        private MimeType dataMimeType;
        private PublicService serviceType;
        private String serviceRegion;
        private List<AuthenticationInformation> authenticationInformation;
        private PaymentInformation paymentInformation;
        private ReplyChannel replyChannel;
        private AdditionalReferenceInfo additionalReferenceInfo = new AdditionalReferenceInfo();
        private Callback callback;
        private List<DataSet> dataSets;
        private Author author;
        private MetadataVersion metadataVersion;
        private static final byte[] EMPTY_DATA = new byte[0];

        private Builder() {
        }

        @Override
        public ServiceTypeStep setDestination(UUID destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        @Override
        public OptionalPropertiesStep addAttachments(List<Attachment> attachments) {
            if (attachments != null && !attachments.isEmpty()) {
                this.attachments.addAll(attachments);
            }
            return this;
        }

        @Override
        public OptionalPropertiesStep addAttachment(Attachment attachment) {
            if (attachment != null) {
                this.attachments.add(attachment);
            }
            return this;
        }

        @Override
        public OptionalPropertiesStep setReplyChannel(ReplyChannel replyChannel) {
            this.replyChannel = replyChannel;
            return this;
        }

        @Override
        public OptionalPropertiesStep setJsonData(String jsonData, URI schemaUri) {
            this.setJsonData(jsonData.getBytes(StandardCharsets.UTF_8), schemaUri);
            return this;
        }

        @Override
        public OptionalPropertiesStep setJsonData(byte[] data, URI schemaUri) {
            this.dataMimeType = MimeType.APPLICATION_JSON;
            this.schemaUri = schemaUri;
            this.data = this.getValidatedData(data);
            return this;
        }

        @Override
        public OptionalPropertiesStep setXmlData(String xmlData, URI schemaUri) {
            this.setXmlData(xmlData.getBytes(StandardCharsets.UTF_8), schemaUri);
            return this;
        }

        @Override
        public OptionalPropertiesStep setXmlData(byte[] data, URI schemaUri) {
            this.dataMimeType = MimeType.APPLICATION_XML;
            this.schemaUri = schemaUri;
            this.data = this.getValidatedData(data);
            return this;
        }

        @Override
        public OptionalPropertiesStep setZBPMessage(CreateMessage message, AuthorKeyPair authorKeyPair) {
            this.data = ZBPEnvelopeBuilder.fromAuthorPayload(message, authorKeyPair);
            this.dataMimeType = MimeType.APPLICATION_JSON;
            this.schemaUri = SchemaConfig.ZBP_ADAPTER_SCHEMA.getSchemaUri();
            return this;
        }

        @Override
        public OptionalPropertiesStep setZBPState(CreateState state, AuthorKeyPair authorKeyPair) {
            this.data = ZBPEnvelopeBuilder.fromAuthorPayload(state, authorKeyPair);
            this.dataMimeType = MimeType.APPLICATION_JSON;
            this.schemaUri = SchemaConfig.ZBP_ADAPTER_SCHEMA.getSchemaUri();
            return this;
        }

        @Override
        public DataStep setServiceType(String serviceIdentifier, String serviceName) {
            this.serviceType = new PublicService(serviceName, serviceIdentifier);
            return this;
        }

        @Override
        public DataStep setServiceTypeWithRegion(String serviceIdentifier, String serviceName, String serviceRegion) {
            this.serviceType = new PublicService(serviceName, serviceIdentifier);
            this.serviceRegion = serviceRegion;
            return this;
        }

        @Override
        public OptionalPropertiesStep setAuthenticationInformation(List<AuthenticationInformation> authenticationInformation) {
            this.authenticationInformation = authenticationInformation;
            return this;
        }

        @Override
        public OptionalPropertiesStep setPaymentInformation(PaymentInformation paymentInformation) {
            this.paymentInformation = paymentInformation;
            return this;
        }

        @Override
        public OptionalPropertiesStep setApplicationDate(LocalDate applicationDate) {
            this.additionalReferenceInfo = this.additionalReferenceInfo.withApplicationDate(applicationDate.toString());
            return this;
        }

        @Override
        public OptionalPropertiesStep setIdBundDeApplicationId(UUID idBundDeApplicationId) {
            this.additionalReferenceInfo = this.additionalReferenceInfo.withIdBundDeApplicationId(idBundDeApplicationId);
            return this;
        }

        @Override
        public OptionalPropertiesStep setSenderReference(String senderReference) {
            this.additionalReferenceInfo = this.additionalReferenceInfo.withSenderReference(senderReference);
            return this;
        }

        @Override
        public OptionalPropertiesStep setCallback(URI callbackUri, String callbackSecret) {
            this.callback = new Callback(callbackUri, callbackSecret);
            return this;
        }

        @Override
        public OptionalPropertiesStep setCase(UUID caseId) {
            this.caseId = caseId;
            return this;
        }

        @Override
        public OptionalPropertiesStep setDataSets(List<DataSet> dataSets) {
            this.dataSets = dataSets;
            return this;
        }

        @Override
        public OptionalPropertiesStep setAuthor(Author author) {
            this.author = author;
            return this;
        }

        @Override
        public OptionalPropertiesStep preferMetadataVersion(MetadataVersion metadataVersion) {
            this.metadataVersion = metadataVersion;
            return this;
        }

        @Override
        public SendableSubmission build() {
            return new SendableSubmission(this);
        }

        private byte[] getValidatedData(byte[] data) {
            if (data.length > 0xD00000) {
                this.attachments.add(Attachment.fromSubmissionData(data, this.dataMimeType));
                return EMPTY_DATA;
            }
            return data;
        }

        @Generated
        public UUID getDestinationId() {
            return this.destinationId;
        }

        @Generated
        public UUID getCaseId() {
            return this.caseId;
        }

        @Generated
        public List<Attachment> getAttachments() {
            return this.attachments;
        }

        @Generated
        public byte[] getData() {
            return this.data;
        }

        @Generated
        public URI getSchemaUri() {
            return this.schemaUri;
        }

        @Generated
        public MimeType getDataMimeType() {
            return this.dataMimeType;
        }

        @Generated
        public PublicService getServiceType() {
            return this.serviceType;
        }

        @Generated
        public String getServiceRegion() {
            return this.serviceRegion;
        }

        @Generated
        public List<AuthenticationInformation> getAuthenticationInformation() {
            return this.authenticationInformation;
        }

        @Generated
        public PaymentInformation getPaymentInformation() {
            return this.paymentInformation;
        }

        @Generated
        public ReplyChannel getReplyChannel() {
            return this.replyChannel;
        }

        @Generated
        public AdditionalReferenceInfo getAdditionalReferenceInfo() {
            return this.additionalReferenceInfo;
        }

        @Generated
        public Callback getCallback() {
            return this.callback;
        }

        @Generated
        public List<DataSet> getDataSets() {
            return this.dataSets;
        }

        @Generated
        public Author getAuthor() {
            return this.author;
        }

        @Generated
        public MetadataVersion getMetadataVersion() {
            return this.metadataVersion;
        }
    }
}

