/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.sender;

import dev.fitko.fitconnect.api.domain.model.callback.Callback;
import dev.fitko.fitconnect.api.domain.model.submission.PublicService;
import dev.fitko.fitconnect.api.domain.sender.steps.encrypted.EncryptedBuildStep;
import dev.fitko.fitconnect.api.domain.sender.steps.encrypted.EncryptedDataStep;
import dev.fitko.fitconnect.api.domain.sender.steps.encrypted.EncryptedDestinationStep;
import dev.fitko.fitconnect.api.domain.sender.steps.encrypted.EncryptedMetadataStep;
import dev.fitko.fitconnect.api.domain.sender.steps.encrypted.EncryptedOptionalPropertiesStep;
import dev.fitko.fitconnect.api.domain.sender.steps.encrypted.EncryptedServiceTypeStep;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public final class SendableEncryptedSubmission {
    private final UUID destinationId;
    private final UUID caseId;
    private final Map<UUID, String> attachments;
    private final String data;
    private final String metadata;
    private final PublicService serviceType;
    private final String serviceRegion;
    private final Callback callback;

    private SendableEncryptedSubmission(Builder builder) {
        this.destinationId = builder.getDestinationId();
        this.caseId = builder.getCaseId();
        this.attachments = Collections.unmodifiableMap(builder.getEncryptedAttachments());
        this.data = builder.getEncryptedData();
        this.metadata = builder.getEncryptedMetadata();
        this.serviceType = builder.getServiceType();
        this.serviceRegion = builder.getServiceRegion();
        this.callback = builder.getCallback();
    }

    public static EncryptedDestinationStep Builder() {
        return new Builder();
    }

    @Generated
    public UUID getDestinationId() {
        return this.destinationId;
    }

    @Generated
    public UUID getCaseId() {
        return this.caseId;
    }

    @Generated
    public Map<UUID, String> getAttachments() {
        return this.attachments;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getMetadata() {
        return this.metadata;
    }

    @Generated
    public PublicService getServiceType() {
        return this.serviceType;
    }

    @Generated
    public String getServiceRegion() {
        return this.serviceRegion;
    }

    @Generated
    public Callback getCallback() {
        return this.callback;
    }

    private static final class Builder
    implements EncryptedDestinationStep,
    EncryptedServiceTypeStep,
    EncryptedMetadataStep,
    EncryptedDataStep,
    EncryptedOptionalPropertiesStep,
    EncryptedBuildStep {
        private UUID destinationId;
        private UUID caseId;
        private PublicService serviceType;
        private String serviceRegion;
        private String encryptedData;
        private String encryptedMetadata;
        private Callback callback;
        private final Map<UUID, String> encryptedAttachments = new HashMap<UUID, String>();

        private Builder() {
        }

        @Override
        public EncryptedServiceTypeStep setDestination(UUID destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        @Override
        public EncryptedOptionalPropertiesStep addEncryptedAttachments(Map<UUID, String> attachments) {
            if (attachments != null) {
                this.encryptedAttachments.putAll(attachments);
            }
            return this;
        }

        @Override
        public EncryptedOptionalPropertiesStep addEncryptedAttachment(UUID id, String content) {
            this.addEncryptedAttachments(Map.of(id, content));
            return this;
        }

        @Override
        public EncryptedOptionalPropertiesStep setCallback(URI callbackUri, String callbackSecret) {
            this.callback = new Callback(callbackUri, callbackSecret);
            return this;
        }

        @Override
        public EncryptedOptionalPropertiesStep setCase(UUID caseID) {
            this.caseId = caseID;
            return this;
        }

        @Override
        public EncryptedOptionalPropertiesStep setEncryptedData(String data) {
            this.encryptedData = data;
            return this;
        }

        @Override
        public EncryptedDataStep setEncryptedMetadata(String encryptedMetadata) {
            this.encryptedMetadata = encryptedMetadata;
            return this;
        }

        @Override
        public EncryptedMetadataStep setServiceType(String serviceIdentifier, String serviceName) {
            this.serviceType = new PublicService(serviceName, serviceIdentifier);
            return this;
        }

        @Override
        public EncryptedMetadataStep setServiceTypeWithRegion(String serviceIdentifier, String serviceName, String serviceRegion) {
            this.serviceType = new PublicService(serviceName, serviceIdentifier);
            this.serviceRegion = serviceRegion;
            return this;
        }

        @Override
        public SendableEncryptedSubmission build() {
            return new SendableEncryptedSubmission(this);
        }

        @Generated
        public UUID getDestinationId() {
            return this.destinationId;
        }

        @Generated
        public UUID getCaseId() {
            return this.caseId;
        }

        @Generated
        public PublicService getServiceType() {
            return this.serviceType;
        }

        @Generated
        public String getServiceRegion() {
            return this.serviceRegion;
        }

        @Generated
        public String getEncryptedData() {
            return this.encryptedData;
        }

        @Generated
        public String getEncryptedMetadata() {
            return this.encryptedMetadata;
        }

        @Generated
        public Callback getCallback() {
            return this.callback;
        }

        @Generated
        public Map<UUID, String> getEncryptedAttachments() {
            return this.encryptedAttachments;
        }
    }
}

