/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.sender;

import dev.fitko.fitconnect.api.FitConnectService;
import dev.fitko.fitconnect.api.domain.model.attachment.Attachment;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.reply.AcceptReply;
import dev.fitko.fitconnect.api.domain.sender.ReceivedReplyData;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class ReceivedReply {
    private final FitConnectService fitConnectService;
    private final ReceivedReplyData receivedReplyData;

    public ReceivedReply(FitConnectService fitConnectService, ReceivedReplyData receivedReplyData) {
        this.fitConnectService = fitConnectService;
        this.receivedReplyData = receivedReplyData;
    }

    public void acceptReply(Problem ... problems) {
        this.fitConnectService.acceptReply(this.receivedReplyData.getReply().getReplyId(), new AcceptReply(Arrays.asList(problems), this.receivedReplyData.getAuthenticationTags()));
    }

    public void rejectReply(List<Problem> problems) {
        this.fitConnectService.rejectReply(this.receivedReplyData.getReply().getReplyId(), problems);
    }

    public String getDataAsString() {
        return new String(this.receivedReplyData.getData(), StandardCharsets.UTF_8);
    }

    public byte[] getDataAsByteArray() {
        return this.receivedReplyData.getData();
    }

    public String getDataMimeType() {
        return this.receivedReplyData.getMetadata().getContentStructure().getData().getSubmissionSchema().getMimeType().value();
    }

    public URI getDataSchemaUri() {
        return this.receivedReplyData.getMetadata().getContentStructure().getData().getSubmissionSchema().getSchemaUri();
    }

    public List<Attachment> getAttachments() {
        return this.receivedReplyData.getAttachments();
    }

    public Metadata getMetadata() {
        return this.receivedReplyData.getMetadata();
    }

    public UUID getCaseId() {
        return this.receivedReplyData.getReply().getCaseId();
    }

    public UUID getReplyId() {
        return this.receivedReplyData.getReply().getReplyId();
    }
}

