/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.routing;

import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;

public final class DestinationSearch {
    private final String leikaKey;
    private final String ars;
    private final String ags;
    private final String areaId;
    private final int offset;
    private final int limit;

    public static MandatoryProperties Builder() {
        return new Builder();
    }

    @Generated
    public String getLeikaKey() {
        return this.leikaKey;
    }

    @Generated
    public String getArs() {
        return this.ars;
    }

    @Generated
    public String getAgs() {
        return this.ags;
    }

    @Generated
    public String getAreaId() {
        return this.areaId;
    }

    @Generated
    public int getOffset() {
        return this.offset;
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DestinationSearch)) {
            return false;
        }
        DestinationSearch other = (DestinationSearch)o;
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        String this$leikaKey = this.getLeikaKey();
        String other$leikaKey = other.getLeikaKey();
        if (this$leikaKey == null ? other$leikaKey != null : !this$leikaKey.equals(other$leikaKey)) {
            return false;
        }
        String this$ars = this.getArs();
        String other$ars = other.getArs();
        if (this$ars == null ? other$ars != null : !this$ars.equals(other$ars)) {
            return false;
        }
        String this$ags = this.getAgs();
        String other$ags = other.getAgs();
        if (this$ags == null ? other$ags != null : !this$ags.equals(other$ags)) {
            return false;
        }
        String this$areaId = this.getAreaId();
        String other$areaId = other.getAreaId();
        return !(this$areaId == null ? other$areaId != null : !this$areaId.equals(other$areaId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOffset();
        result = result * 59 + this.getLimit();
        String $leikaKey = this.getLeikaKey();
        result = result * 59 + ($leikaKey == null ? 43 : $leikaKey.hashCode());
        String $ars = this.getArs();
        result = result * 59 + ($ars == null ? 43 : $ars.hashCode());
        String $ags = this.getAgs();
        result = result * 59 + ($ags == null ? 43 : $ags.hashCode());
        String $areaId = this.getAreaId();
        result = result * 59 + ($areaId == null ? 43 : $areaId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DestinationSearch(leikaKey=" + this.getLeikaKey() + ", ars=" + this.getArs() + ", ags=" + this.getAgs() + ", areaId=" + this.getAreaId() + ", offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }

    @Generated
    public DestinationSearch(String leikaKey, String ars, String ags, String areaId, int offset, int limit) {
        this.leikaKey = leikaKey;
        this.ars = ars;
        this.ags = ags;
        this.areaId = areaId;
        this.offset = offset;
        this.limit = limit;
    }

    private static class Builder
    implements MandatoryProperties,
    OptionalProperties,
    Pagination,
    BuildSearch {
        private static final Pattern AGS_PATTERN = Pattern.compile("^(\\d{2}|\\d{3}|\\d{5}|\\d{8})$");
        private static final Pattern ARS_PATTERN = Pattern.compile("^(\\d{2}|\\d{3}|\\d{5}|\\d{9}|\\d{12})$");
        private static final Pattern AREA_ID_PATTERN = Pattern.compile("^\\d{1,}");
        private static final Pattern LEIKA_KEY_PATTERN = Pattern.compile("^99\\d{12}$");
        private String leikaKey;
        private String ars;
        private String ags;
        private String areaId;
        private int offset = 0;
        private int limit = 100;

        private Builder() {
        }

        @Override
        public OptionalProperties withLeikaKey(String leikaKey) throws IllegalArgumentException {
            if (!LEIKA_KEY_PATTERN.matcher(leikaKey).matches()) {
                throw new IllegalArgumentException("Leika key does not match allowed pattern " + String.valueOf(LEIKA_KEY_PATTERN));
            }
            this.leikaKey = leikaKey;
            return this;
        }

        @Override
        public Pagination withArs(String ars) throws IllegalArgumentException {
            if (!ARS_PATTERN.matcher(ars).matches()) {
                throw new IllegalArgumentException("ARS key does not match allowed pattern " + String.valueOf(ARS_PATTERN));
            }
            this.ars = ars;
            return this;
        }

        @Override
        public Pagination withAgs(String ags) throws IllegalArgumentException {
            if (!AGS_PATTERN.matcher(ags).matches()) {
                throw new IllegalArgumentException("AGS key does not match allowed pattern " + String.valueOf(AGS_PATTERN));
            }
            this.ags = ags;
            return this;
        }

        @Override
        public Pagination withAreaId(String areaId) throws IllegalArgumentException {
            if (!AREA_ID_PATTERN.matcher(areaId).matches()) {
                throw new IllegalArgumentException("AreaId key does not match allowed pattern " + String.valueOf(AREA_ID_PATTERN));
            }
            this.areaId = areaId;
            return this;
        }

        @Override
        public Builder withOffset(int offset) throws IllegalArgumentException {
            if (this.limit < 0) {
                throw new IllegalArgumentException("offset must be positive");
            }
            this.offset = offset;
            return this;
        }

        @Override
        public Builder withLimit(int limit) throws IllegalArgumentException {
            if (limit > 500) {
                throw new IllegalArgumentException("limit must not be > 500");
            }
            this.limit = limit;
            return this;
        }

        @Override
        public DestinationSearch build() throws IllegalArgumentException {
            if (this.leikaKey == null) {
                throw new IllegalArgumentException("leikaKey must not be null");
            }
            if (Stream.of(this.areaId, this.ags, this.ars).allMatch(Objects::isNull)) {
                throw new IllegalArgumentException("at least one regional search criterion (areaId, ars or ags) is mandatory");
            }
            return new DestinationSearch(this.leikaKey, this.ars, this.ags, this.areaId, this.offset, this.limit);
        }
    }

    public static interface BuildSearch {
        public DestinationSearch build() throws IllegalArgumentException;
    }

    public static interface Pagination {
        public Pagination withOffset(int var1) throws IllegalArgumentException;

        public Pagination withLimit(int var1) throws IllegalArgumentException;

        public DestinationSearch build() throws IllegalArgumentException;
    }

    public static interface OptionalProperties {
        public Pagination withArs(String var1) throws IllegalArgumentException;

        public Pagination withAgs(String var1) throws IllegalArgumentException;

        public Pagination withAreaId(String var1) throws IllegalArgumentException;

        public Builder withOffset(int var1) throws IllegalArgumentException;

        public Builder withLimit(int var1) throws IllegalArgumentException;

        public DestinationSearch build() throws IllegalArgumentException;
    }

    public static interface MandatoryProperties {
        public OptionalProperties withLeikaKey(String var1) throws IllegalArgumentException;
    }
}

