/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.reply.replychannel;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.nimbusds.jose.jwk.JWK;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.DeMail;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.Elster;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.Email;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.EncryptionPublicKey;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.Fink;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.FitConnect;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.IdBundDeMailbox;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ReplyChannel {
    private DeMail deMail;
    private Elster elster;
    private Email email;
    private Fink fink;
    private FitConnect fitConnect;
    private IdBundDeMailbox idBundDeMailbox;

    private ReplyChannel(Fink fink) {
        this.fink = fink;
    }

    private ReplyChannel(Email email) {
        this.email = email;
    }

    private ReplyChannel(DeMail deMail) {
        this.deMail = deMail;
    }

    private ReplyChannel(Elster elster) {
        this.elster = elster;
    }

    private ReplyChannel(FitConnect fitConnect) {
        this.fitConnect = fitConnect;
    }

    private ReplyChannel(IdBundDeMailbox idBundDeMailbox) {
        this.idBundDeMailbox = idBundDeMailbox;
    }

    public static ReplyChannel ofFink(String finkPostboxRef, String host) {
        return new ReplyChannel(new Fink(finkPostboxRef, host));
    }

    public static ReplyChannel ofEmailWithPgp(String address, String pgpPublicKey) {
        return new ReplyChannel(new Email(address, true, pgpPublicKey));
    }

    public static ReplyChannel ofEmail(String address) {
        return new ReplyChannel(new Email(address, false, null));
    }

    public static ReplyChannel ofDeMail(String address) {
        return new ReplyChannel(new DeMail(address));
    }

    public static ReplyChannel ofElster(String accountId, String deliveryTicket, String reference) {
        return new ReplyChannel(new Elster(accountId, deliveryTicket, reference));
    }

    public static ReplyChannel ofFitConnect(JWK encryptionKey, List<String> processStandards) {
        return new ReplyChannel(new FitConnect(EncryptionPublicKey.fromJwk(encryptionKey), processStandards));
    }

    public static ReplyChannel ofIdBundDeMailbox(UUID mailboxId) {
        return new ReplyChannel(new IdBundDeMailbox(mailboxId));
    }

    public boolean isDeMail() {
        return this.deMail != null;
    }

    public boolean isElster() {
        return this.elster != null;
    }

    public boolean isEMail() {
        return this.email != null;
    }

    public boolean isFink() {
        return this.fink != null;
    }

    public boolean isFitConnect() {
        return this.fitConnect != null;
    }

    public boolean isIdBundDeMailbox() {
        return this.idBundDeMailbox != null;
    }

    @JsonGetter(value="deMail")
    public DeMail getDeMail() {
        return this.deMail;
    }

    @JsonGetter(value="elster")
    public Elster getElster() {
        return this.elster;
    }

    @JsonGetter(value="eMail")
    public Email getEmail() {
        return this.email;
    }

    @JsonGetter(value="fink")
    public Fink getFink() {
        return this.fink;
    }

    @JsonGetter(value="fitConnect")
    public FitConnect getFitConnect() {
        return this.fitConnect;
    }

    @JsonGetter(value="idBundDeMailbox")
    public IdBundDeMailbox getIdBundDeMailbox() {
        return this.idBundDeMailbox;
    }

    @Generated
    public void setDeMail(DeMail deMail) {
        this.deMail = deMail;
    }

    @Generated
    public void setElster(Elster elster) {
        this.elster = elster;
    }

    @Generated
    public void setEmail(Email email) {
        this.email = email;
    }

    @Generated
    public void setFink(Fink fink) {
        this.fink = fink;
    }

    @Generated
    public void setFitConnect(FitConnect fitConnect) {
        this.fitConnect = fitConnect;
    }

    @Generated
    public void setIdBundDeMailbox(IdBundDeMailbox idBundDeMailbox) {
        this.idBundDeMailbox = idBundDeMailbox;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplyChannel)) {
            return false;
        }
        ReplyChannel other = (ReplyChannel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeMail this$deMail = this.getDeMail();
        DeMail other$deMail = other.getDeMail();
        if (this$deMail == null ? other$deMail != null : !((Object)this$deMail).equals(other$deMail)) {
            return false;
        }
        Elster this$elster = this.getElster();
        Elster other$elster = other.getElster();
        if (this$elster == null ? other$elster != null : !((Object)this$elster).equals(other$elster)) {
            return false;
        }
        Email this$email = this.getEmail();
        Email other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        Fink this$fink = this.getFink();
        Fink other$fink = other.getFink();
        if (this$fink == null ? other$fink != null : !((Object)this$fink).equals(other$fink)) {
            return false;
        }
        FitConnect this$fitConnect = this.getFitConnect();
        FitConnect other$fitConnect = other.getFitConnect();
        if (this$fitConnect == null ? other$fitConnect != null : !this$fitConnect.equals(other$fitConnect)) {
            return false;
        }
        IdBundDeMailbox this$idBundDeMailbox = this.getIdBundDeMailbox();
        IdBundDeMailbox other$idBundDeMailbox = other.getIdBundDeMailbox();
        return !(this$idBundDeMailbox == null ? other$idBundDeMailbox != null : !((Object)this$idBundDeMailbox).equals(other$idBundDeMailbox));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReplyChannel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeMail $deMail = this.getDeMail();
        result = result * 59 + ($deMail == null ? 43 : ((Object)$deMail).hashCode());
        Elster $elster = this.getElster();
        result = result * 59 + ($elster == null ? 43 : ((Object)$elster).hashCode());
        Email $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        Fink $fink = this.getFink();
        result = result * 59 + ($fink == null ? 43 : ((Object)$fink).hashCode());
        FitConnect $fitConnect = this.getFitConnect();
        result = result * 59 + ($fitConnect == null ? 43 : $fitConnect.hashCode());
        IdBundDeMailbox $idBundDeMailbox = this.getIdBundDeMailbox();
        result = result * 59 + ($idBundDeMailbox == null ? 43 : ((Object)$idBundDeMailbox).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReplyChannel(deMail=" + String.valueOf(this.getDeMail()) + ", elster=" + String.valueOf(this.getElster()) + ", email=" + String.valueOf(this.getEmail()) + ", fink=" + String.valueOf(this.getFink()) + ", fitConnect=" + String.valueOf(this.getFitConnect()) + ", idBundDeMailbox=" + String.valueOf(this.getIdBundDeMailbox()) + ")";
    }

    @Generated
    public ReplyChannel() {
    }

    @Generated
    public ReplyChannel(DeMail deMail, Elster elster, Email email, Fink fink, FitConnect fitConnect, IdBundDeMailbox idBundDeMailbox) {
        this.deMail = deMail;
        this.elster = elster;
        this.email = email;
        this.fink = fink;
        this.fitConnect = fitConnect;
        this.idBundDeMailbox = idBundDeMailbox;
    }
}

