/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.reply.replychannel;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.JWK;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class EncryptionPublicKey {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @JsonProperty(value="kty")
    private String kty;
    @JsonProperty(value="key_ops")
    private List<String> keyOps = new ArrayList<String>();
    @JsonProperty(value="alg")
    private String alg;
    @JsonProperty(value="kid")
    private String kid;
    @JsonProperty(value="n")
    private String n;
    @JsonProperty(value="e")
    private String e;

    public static EncryptionPublicKey fromJwk(JWK jwk) {
        Map jsonObject = jwk.toJSONObject();
        try {
            return (EncryptionPublicKey)MAPPER.readValue(MAPPER.writeValueAsString((Object)jsonObject), EncryptionPublicKey.class);
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JWK toJwk() {
        try {
            return JWK.parse((String)MAPPER.writeValueAsString((Object)this));
        }
        catch (JsonProcessingException | ParseException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Generated
    public String getKty() {
        return this.kty;
    }

    @Generated
    public List<String> getKeyOps() {
        return this.keyOps;
    }

    @Generated
    public String getAlg() {
        return this.alg;
    }

    @Generated
    public String getKid() {
        return this.kid;
    }

    @Generated
    public String getN() {
        return this.n;
    }

    @Generated
    public String getE() {
        return this.e;
    }

    @Generated
    public void setKty(String kty) {
        this.kty = kty;
    }

    @Generated
    public void setKeyOps(List<String> keyOps) {
        this.keyOps = keyOps;
    }

    @Generated
    public void setAlg(String alg) {
        this.alg = alg;
    }

    @Generated
    public void setKid(String kid) {
        this.kid = kid;
    }

    @Generated
    public void setN(String n) {
        this.n = n;
    }

    @Generated
    public void setE(String e) {
        this.e = e;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EncryptionPublicKey)) {
            return false;
        }
        EncryptionPublicKey other = (EncryptionPublicKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$kty = this.getKty();
        String other$kty = other.getKty();
        if (this$kty == null ? other$kty != null : !this$kty.equals(other$kty)) {
            return false;
        }
        List<String> this$keyOps = this.getKeyOps();
        List<String> other$keyOps = other.getKeyOps();
        if (this$keyOps == null ? other$keyOps != null : !((Object)this$keyOps).equals(other$keyOps)) {
            return false;
        }
        String this$alg = this.getAlg();
        String other$alg = other.getAlg();
        if (this$alg == null ? other$alg != null : !this$alg.equals(other$alg)) {
            return false;
        }
        String this$kid = this.getKid();
        String other$kid = other.getKid();
        if (this$kid == null ? other$kid != null : !this$kid.equals(other$kid)) {
            return false;
        }
        String this$n = this.getN();
        String other$n = other.getN();
        if (this$n == null ? other$n != null : !this$n.equals(other$n)) {
            return false;
        }
        String this$e = this.getE();
        String other$e = other.getE();
        return !(this$e == null ? other$e != null : !this$e.equals(other$e));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EncryptionPublicKey;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $kty = this.getKty();
        result = result * 59 + ($kty == null ? 43 : $kty.hashCode());
        List<String> $keyOps = this.getKeyOps();
        result = result * 59 + ($keyOps == null ? 43 : ((Object)$keyOps).hashCode());
        String $alg = this.getAlg();
        result = result * 59 + ($alg == null ? 43 : $alg.hashCode());
        String $kid = this.getKid();
        result = result * 59 + ($kid == null ? 43 : $kid.hashCode());
        String $n = this.getN();
        result = result * 59 + ($n == null ? 43 : $n.hashCode());
        String $e = this.getE();
        result = result * 59 + ($e == null ? 43 : $e.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EncryptionPublicKey(kty=" + this.getKty() + ", keyOps=" + String.valueOf(this.getKeyOps()) + ", alg=" + this.getAlg() + ", kid=" + this.getKid() + ", n=" + this.getN() + ", e=" + this.getE() + ")";
    }

    @Generated
    public EncryptionPublicKey() {
    }

    @Generated
    public EncryptionPublicKey(String kty, List<String> keyOps, String alg, String kid, String n, String e) {
        this.kty = kty;
        this.keyOps = keyOps;
        this.alg = alg;
        this.kid = kid;
        this.n = n;
        this.e = e;
    }
}

