/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.metadata.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum MimeType {
    APPLICATION_JSON("application/json"),
    APPLICATION_XML("application/xml"),
    PLAIN_TEXT("text/plain"),
    APPLICATION_OCTET_STREAM("application/octet-stream"),
    APPLICATION_PDF("application/pdf");

    private static final Map<String, MimeType> CONSTANTS;
    private final String value;

    private MimeType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static MimeType fromValue(String value) {
        MimeType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }

    public String getExtension() {
        return this.value.split("/")[1];
    }

    static {
        CONSTANTS = new HashMap<String, MimeType>();
        for (MimeType c : MimeType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

