/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.metadata.attachment;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Purpose {
    FORM("form"),
    ATTACHMENT("attachment"),
    REPORT("report"),
    DATA("data");

    private final String value;
    private static final Map<String, Purpose> CONSTANTS;

    private Purpose(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Purpose fromValue(String value) {
        Purpose constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Purpose>();
        for (Purpose p : Purpose.values()) {
            CONSTANTS.put(p.value, p);
        }
    }
}

