/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.metadata.attachment;

import dev.fitko.fitconnect.api.domain.model.attachment.Fragment;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.ApiAttachment;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.Purpose;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

public final class AttachmentForValidation {
    private UUID attachmentId;
    private String hash;
    private byte[] decryptedData;
    private String authTag;
    private ApiAttachment attachmentMetadata;
    private List<Fragment> fragments;
    private File dataFile;

    private AttachmentForValidation(ApiAttachment attachmentMetadata, byte[] decryptedData, String authTag, List<Fragment> fragments, File dataFile) {
        this.attachmentMetadata = attachmentMetadata;
        this.decryptedData = decryptedData;
        this.authTag = authTag;
        this.dataFile = dataFile;
        this.fragments = fragments;
        this.attachmentId = attachmentMetadata.getAttachmentId();
        this.hash = attachmentMetadata.getHash().getContent();
    }

    public static AttachmentForValidation forFragmentedAttachment(ApiAttachment attachmentMetadata, List<Fragment> fragments, File mergedFile) {
        return new AttachmentForValidation(attachmentMetadata, null, null, fragments, mergedFile);
    }

    public static AttachmentForValidation forAttachmentWithoutFragments(ApiAttachment attachmentMetadata, byte[] decryptedData, String authTag) {
        return new AttachmentForValidation(attachmentMetadata, decryptedData, authTag, Collections.emptyList(), null);
    }

    public boolean hasFragmentedPayload() {
        return !this.fragments.isEmpty();
    }

    public boolean isDataAttachment() {
        return this.attachmentMetadata.getPurpose().equals((Object)Purpose.DATA);
    }

    @Generated
    public UUID getAttachmentId() {
        return this.attachmentId;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public byte[] getDecryptedData() {
        return this.decryptedData;
    }

    @Generated
    public String getAuthTag() {
        return this.authTag;
    }

    @Generated
    public ApiAttachment getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    @Generated
    public List<Fragment> getFragments() {
        return this.fragments;
    }

    @Generated
    public File getDataFile() {
        return this.dataFile;
    }

    @Generated
    public void setAttachmentId(UUID attachmentId) {
        this.attachmentId = attachmentId;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setDecryptedData(byte[] decryptedData) {
        this.decryptedData = decryptedData;
    }

    @Generated
    public void setAuthTag(String authTag) {
        this.authTag = authTag;
    }

    @Generated
    public void setAttachmentMetadata(ApiAttachment attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata;
    }

    @Generated
    public void setFragments(List<Fragment> fragments) {
        this.fragments = fragments;
    }

    @Generated
    public void setDataFile(File dataFile) {
        this.dataFile = dataFile;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttachmentForValidation)) {
            return false;
        }
        AttachmentForValidation other = (AttachmentForValidation)o;
        UUID this$attachmentId = this.getAttachmentId();
        UUID other$attachmentId = other.getAttachmentId();
        if (this$attachmentId == null ? other$attachmentId != null : !((Object)this$attachmentId).equals(other$attachmentId)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        if (!Arrays.equals(this.getDecryptedData(), other.getDecryptedData())) {
            return false;
        }
        String this$authTag = this.getAuthTag();
        String other$authTag = other.getAuthTag();
        if (this$authTag == null ? other$authTag != null : !this$authTag.equals(other$authTag)) {
            return false;
        }
        ApiAttachment this$attachmentMetadata = this.getAttachmentMetadata();
        ApiAttachment other$attachmentMetadata = other.getAttachmentMetadata();
        if (this$attachmentMetadata == null ? other$attachmentMetadata != null : !((Object)this$attachmentMetadata).equals(other$attachmentMetadata)) {
            return false;
        }
        List<Fragment> this$fragments = this.getFragments();
        List<Fragment> other$fragments = other.getFragments();
        if (this$fragments == null ? other$fragments != null : !((Object)this$fragments).equals(other$fragments)) {
            return false;
        }
        File this$dataFile = this.getDataFile();
        File other$dataFile = other.getDataFile();
        return !(this$dataFile == null ? other$dataFile != null : !((Object)this$dataFile).equals(other$dataFile));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $attachmentId = this.getAttachmentId();
        result = result * 59 + ($attachmentId == null ? 43 : ((Object)$attachmentId).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        result = result * 59 + Arrays.hashCode(this.getDecryptedData());
        String $authTag = this.getAuthTag();
        result = result * 59 + ($authTag == null ? 43 : $authTag.hashCode());
        ApiAttachment $attachmentMetadata = this.getAttachmentMetadata();
        result = result * 59 + ($attachmentMetadata == null ? 43 : ((Object)$attachmentMetadata).hashCode());
        List<Fragment> $fragments = this.getFragments();
        result = result * 59 + ($fragments == null ? 43 : ((Object)$fragments).hashCode());
        File $dataFile = this.getDataFile();
        result = result * 59 + ($dataFile == null ? 43 : ((Object)$dataFile).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AttachmentForValidation(attachmentId=" + String.valueOf(this.getAttachmentId()) + ", hash=" + this.getHash() + ", decryptedData=" + Arrays.toString(this.getDecryptedData()) + ", authTag=" + this.getAuthTag() + ", attachmentMetadata=" + String.valueOf(this.getAttachmentMetadata()) + ", fragments=" + String.valueOf(this.getFragments()) + ", dataFile=" + String.valueOf(this.getDataFile()) + ")";
    }

    @Generated
    public AttachmentForValidation(UUID attachmentId, String hash, byte[] decryptedData, String authTag, ApiAttachment attachmentMetadata, List<Fragment> fragments, File dataFile) {
        this.attachmentId = attachmentId;
        this.hash = hash;
        this.decryptedData = decryptedData;
        this.authTag = authTag;
        this.attachmentMetadata = attachmentMetadata;
        this.fragments = fragments;
        this.dataFile = dataFile;
    }

    @Generated
    public AttachmentForValidation() {
    }
}

