/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SignatureType {
    SHA_512("sha512");

    private static final Map<String, SignatureType> CONSTANTS;
    private final String value;

    private SignatureType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SignatureType fromValue(String value) {
        SignatureType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SignatureType>();
        for (SignatureType c : SignatureType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

