/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum SignatureFormat {
    CMS("cms"),
    XML("xml"),
    PDF("pdf"),
    ASIC("asic"),
    JSON("json");

    private static final Map<String, SignatureFormat> CONSTANTS;
    private final String value;

    private SignatureFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SignatureFormat fromValue(String value) {
        SignatureFormat constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, SignatureFormat>();
        for (SignatureFormat c : SignatureFormat.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

