/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.jwk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum KeyOpsEnum {
    VERIFY("verify"),
    WRAPKEY("wrapKey");

    private static final Map<String, KeyOpsEnum> CONSTANTS;
    private final String value;

    private KeyOpsEnum(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static KeyOpsEnum fromValue(String value) {
        KeyOpsEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, KeyOpsEnum>();
        for (KeyOpsEnum c : KeyOpsEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

