/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.jwk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum AlgEnum {
    PS512("PS512"),
    RSA_OAEP_256("RSA-OAEP-256");

    private static final Map<String, AlgEnum> CONSTANTS;
    private final String value;

    private AlgEnum(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static AlgEnum fromValue(String value) {
        AlgEnum constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, AlgEnum>();
        for (AlgEnum c : AlgEnum.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

