/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.event.authtags;

import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import lombok.Generated;

public class ValidatedAuthenticationTags {
    private AuthenticationTags authenticationTags;
    private boolean isValid;
    private Problem problem;
    private String errorMessage;

    public boolean causesRejection() {
        return !this.isValid && this.problem != null;
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.problem.getDetail() + "\n" + this.errorMessage : this.problem.getDetail();
    }

    public static ValidatedAuthenticationTags fromValidTags(AuthenticationTags authenticationTags) {
        return new ValidatedAuthenticationTags(authenticationTags, true, null, null);
    }

    public static ValidatedAuthenticationTags fromInvalidTags(Problem problem, String errorMessage) {
        return new ValidatedAuthenticationTags(null, false, problem, errorMessage);
    }

    public static ValidatedAuthenticationTags fromInvalidTags(Problem problem) {
        return new ValidatedAuthenticationTags(null, false, problem, null);
    }

    @Generated
    public AuthenticationTags getAuthenticationTags() {
        return this.authenticationTags;
    }

    @Generated
    public boolean isValid() {
        return this.isValid;
    }

    @Generated
    public Problem getProblem() {
        return this.problem;
    }

    @Generated
    public ValidatedAuthenticationTags(AuthenticationTags authenticationTags, boolean isValid, Problem problem, String errorMessage) {
        this.authenticationTags = authenticationTags;
        this.isValid = isValid;
        this.problem = problem;
        this.errorMessage = errorMessage;
    }
}

