/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.event.authtags;

import com.nimbusds.jose.JWEObject;
import dev.fitko.fitconnect.api.exceptions.internal.AuthenticationTagException;
import java.text.ParseException;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class AuthenticationTags {
    private String metadata;
    private String data;
    private Map<UUID, String> attachments;

    public AuthenticationTags(String dataAuthTag, String metadataAuthTag, Map<UUID, String> attachmentAuthTags) {
        this.data = dataAuthTag;
        this.metadata = metadataAuthTag;
        this.attachments = attachmentAuthTags;
    }

    public static AuthenticationTags fromEncryptedData(String encryptedData, String encryptedMetadata) {
        String dataAuthTag = AuthenticationTags.getAuthTagFromJWT(encryptedData);
        String metadataAuthTag = AuthenticationTags.getAuthTagFromJWT(encryptedMetadata);
        return new AuthenticationTags(dataAuthTag, metadataAuthTag, null);
    }

    public static String getAuthTagFromJWT(String base64EncodedJWT) throws AuthenticationTagException {
        if (base64EncodedJWT == null) {
            return null;
        }
        try {
            return JWEObject.parse((String)base64EncodedJWT).getAuthTag().toString();
        }
        catch (ParseException e) {
            throw new AuthenticationTagException(e.getMessage(), e);
        }
    }

    @Generated
    public String getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public Map<UUID, String> getAttachments() {
        return this.attachments;
    }

    @Generated
    public void setMetadata(String metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setAttachments(Map<UUID, String> attachments) {
        this.attachments = attachments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationTags)) {
            return false;
        }
        AuthenticationTags other = (AuthenticationTags)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$metadata = this.getMetadata();
        String other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Map<UUID, String> this$attachments = this.getAttachments();
        Map<UUID, String> other$attachments = other.getAttachments();
        return !(this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuthenticationTags;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : $metadata.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Map<UUID, String> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AuthenticationTags(metadata=" + this.getMetadata() + ", data=" + this.getData() + ", attachments=" + String.valueOf(this.getAttachments()) + ")";
    }

    @Generated
    public AuthenticationTags() {
    }
}

