/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.event;

import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.domain.model.submission.SubmissionForPickup;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;

public class EventPayload {
    private UUID submissionId;
    private UUID destinationId;
    private UUID caseId;
    private String metadataAuthTag;
    private String dataAuthTag;
    private Map<UUID, String> attachmentAuthTags;
    private List<Problem> problems;

    public static EventPayload forRejectEvent(SubmissionForPickup submission, List<Problem> problems) {
        return EventPayload.builder().submissionId(submission.getSubmissionId()).destinationId(submission.getDestinationId()).caseId(submission.getCaseId()).problems(problems).build();
    }

    public static EventPayload forRejectEvent(Submission submission, List<Problem> problems) {
        return EventPayload.builder().submissionId(submission.getSubmissionId()).destinationId(submission.getDestinationId()).caseId(submission.getCaseId()).problems(problems).build();
    }

    public static EventPayload forAcceptEvent(Submission submission, Problem ... problems) {
        return EventPayload.builder().submissionId(submission.getSubmissionId()).destinationId(submission.getDestinationId()).caseId(submission.getCaseId()).dataAuthTag(AuthenticationTags.getAuthTagFromJWT(submission.getEncryptedData())).metadataAuthTag(AuthenticationTags.getAuthTagFromJWT(submission.getEncryptedMetadata())).attachmentAuthTags(Collections.emptyMap()).problems(Arrays.asList(problems)).build();
    }

    public static EventPayload forAcceptEventWithAttachments(Submission submission, Map<UUID, String> attachmentAuthTags, Problem ... problems) {
        return EventPayload.builder().submissionId(submission.getSubmissionId()).destinationId(submission.getDestinationId()).caseId(submission.getCaseId()).dataAuthTag(AuthenticationTags.getAuthTagFromJWT(submission.getEncryptedData())).metadataAuthTag(AuthenticationTags.getAuthTagFromJWT(submission.getEncryptedMetadata())).attachmentAuthTags(attachmentAuthTags).problems(Arrays.asList(problems)).build();
    }

    @Generated
    public static EventPayloadBuilder builder() {
        return new EventPayloadBuilder();
    }

    @Generated
    public UUID getSubmissionId() {
        return this.submissionId;
    }

    @Generated
    public UUID getDestinationId() {
        return this.destinationId;
    }

    @Generated
    public UUID getCaseId() {
        return this.caseId;
    }

    @Generated
    public String getMetadataAuthTag() {
        return this.metadataAuthTag;
    }

    @Generated
    public String getDataAuthTag() {
        return this.dataAuthTag;
    }

    @Generated
    public Map<UUID, String> getAttachmentAuthTags() {
        return this.attachmentAuthTags;
    }

    @Generated
    public List<Problem> getProblems() {
        return this.problems;
    }

    @Generated
    public void setSubmissionId(UUID submissionId) {
        this.submissionId = submissionId;
    }

    @Generated
    public void setDestinationId(UUID destinationId) {
        this.destinationId = destinationId;
    }

    @Generated
    public void setCaseId(UUID caseId) {
        this.caseId = caseId;
    }

    @Generated
    public void setMetadataAuthTag(String metadataAuthTag) {
        this.metadataAuthTag = metadataAuthTag;
    }

    @Generated
    public void setDataAuthTag(String dataAuthTag) {
        this.dataAuthTag = dataAuthTag;
    }

    @Generated
    public void setAttachmentAuthTags(Map<UUID, String> attachmentAuthTags) {
        this.attachmentAuthTags = attachmentAuthTags;
    }

    @Generated
    public void setProblems(List<Problem> problems) {
        this.problems = problems;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventPayload)) {
            return false;
        }
        EventPayload other = (EventPayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$submissionId = this.getSubmissionId();
        UUID other$submissionId = other.getSubmissionId();
        if (this$submissionId == null ? other$submissionId != null : !((Object)this$submissionId).equals(other$submissionId)) {
            return false;
        }
        UUID this$destinationId = this.getDestinationId();
        UUID other$destinationId = other.getDestinationId();
        if (this$destinationId == null ? other$destinationId != null : !((Object)this$destinationId).equals(other$destinationId)) {
            return false;
        }
        UUID this$caseId = this.getCaseId();
        UUID other$caseId = other.getCaseId();
        if (this$caseId == null ? other$caseId != null : !((Object)this$caseId).equals(other$caseId)) {
            return false;
        }
        String this$metadataAuthTag = this.getMetadataAuthTag();
        String other$metadataAuthTag = other.getMetadataAuthTag();
        if (this$metadataAuthTag == null ? other$metadataAuthTag != null : !this$metadataAuthTag.equals(other$metadataAuthTag)) {
            return false;
        }
        String this$dataAuthTag = this.getDataAuthTag();
        String other$dataAuthTag = other.getDataAuthTag();
        if (this$dataAuthTag == null ? other$dataAuthTag != null : !this$dataAuthTag.equals(other$dataAuthTag)) {
            return false;
        }
        Map<UUID, String> this$attachmentAuthTags = this.getAttachmentAuthTags();
        Map<UUID, String> other$attachmentAuthTags = other.getAttachmentAuthTags();
        if (this$attachmentAuthTags == null ? other$attachmentAuthTags != null : !((Object)this$attachmentAuthTags).equals(other$attachmentAuthTags)) {
            return false;
        }
        List<Problem> this$problems = this.getProblems();
        List<Problem> other$problems = other.getProblems();
        return !(this$problems == null ? other$problems != null : !((Object)this$problems).equals(other$problems));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EventPayload;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $submissionId = this.getSubmissionId();
        result = result * 59 + ($submissionId == null ? 43 : ((Object)$submissionId).hashCode());
        UUID $destinationId = this.getDestinationId();
        result = result * 59 + ($destinationId == null ? 43 : ((Object)$destinationId).hashCode());
        UUID $caseId = this.getCaseId();
        result = result * 59 + ($caseId == null ? 43 : ((Object)$caseId).hashCode());
        String $metadataAuthTag = this.getMetadataAuthTag();
        result = result * 59 + ($metadataAuthTag == null ? 43 : $metadataAuthTag.hashCode());
        String $dataAuthTag = this.getDataAuthTag();
        result = result * 59 + ($dataAuthTag == null ? 43 : $dataAuthTag.hashCode());
        Map<UUID, String> $attachmentAuthTags = this.getAttachmentAuthTags();
        result = result * 59 + ($attachmentAuthTags == null ? 43 : ((Object)$attachmentAuthTags).hashCode());
        List<Problem> $problems = this.getProblems();
        result = result * 59 + ($problems == null ? 43 : ((Object)$problems).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EventPayload(submissionId=" + String.valueOf(this.getSubmissionId()) + ", destinationId=" + String.valueOf(this.getDestinationId()) + ", caseId=" + String.valueOf(this.getCaseId()) + ", metadataAuthTag=" + this.getMetadataAuthTag() + ", dataAuthTag=" + this.getDataAuthTag() + ", attachmentAuthTags=" + String.valueOf(this.getAttachmentAuthTags()) + ", problems=" + String.valueOf(this.getProblems()) + ")";
    }

    @Generated
    public EventPayload(UUID submissionId, UUID destinationId, UUID caseId, String metadataAuthTag, String dataAuthTag, Map<UUID, String> attachmentAuthTags, List<Problem> problems) {
        this.submissionId = submissionId;
        this.destinationId = destinationId;
        this.caseId = caseId;
        this.metadataAuthTag = metadataAuthTag;
        this.dataAuthTag = dataAuthTag;
        this.attachmentAuthTags = attachmentAuthTags;
        this.problems = problems;
    }

    @Generated
    public static class EventPayloadBuilder {
        @Generated
        private UUID submissionId;
        @Generated
        private UUID destinationId;
        @Generated
        private UUID caseId;
        @Generated
        private String metadataAuthTag;
        @Generated
        private String dataAuthTag;
        @Generated
        private Map<UUID, String> attachmentAuthTags;
        @Generated
        private List<Problem> problems;

        @Generated
        EventPayloadBuilder() {
        }

        @Generated
        public EventPayloadBuilder submissionId(UUID submissionId) {
            this.submissionId = submissionId;
            return this;
        }

        @Generated
        public EventPayloadBuilder destinationId(UUID destinationId) {
            this.destinationId = destinationId;
            return this;
        }

        @Generated
        public EventPayloadBuilder caseId(UUID caseId) {
            this.caseId = caseId;
            return this;
        }

        @Generated
        public EventPayloadBuilder metadataAuthTag(String metadataAuthTag) {
            this.metadataAuthTag = metadataAuthTag;
            return this;
        }

        @Generated
        public EventPayloadBuilder dataAuthTag(String dataAuthTag) {
            this.dataAuthTag = dataAuthTag;
            return this;
        }

        @Generated
        public EventPayloadBuilder attachmentAuthTags(Map<UUID, String> attachmentAuthTags) {
            this.attachmentAuthTags = attachmentAuthTags;
            return this;
        }

        @Generated
        public EventPayloadBuilder problems(List<Problem> problems) {
            this.problems = problems;
            return this;
        }

        @Generated
        public EventPayload build() {
            return new EventPayload(this.submissionId, this.destinationId, this.caseId, this.metadataAuthTag, this.dataAuthTag, this.attachmentAuthTags, this.problems);
        }

        @Generated
        public String toString() {
            return "EventPayload.EventPayloadBuilder(submissionId=" + String.valueOf(this.submissionId) + ", destinationId=" + String.valueOf(this.destinationId) + ", caseId=" + String.valueOf(this.caseId) + ", metadataAuthTag=" + this.metadataAuthTag + ", dataAuthTag=" + this.dataAuthTag + ", attachmentAuthTags=" + String.valueOf(this.attachmentAuthTags) + ", problems=" + String.valueOf(this.problems) + ")";
        }
    }
}

