/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.event;

import dev.fitko.fitconnect.api.config.defaults.SchemaConfig;
import dev.fitko.fitconnect.api.domain.model.event.EventState;
import java.util.HashMap;
import java.util.Map;

public enum Event {
    CREATE_SUBMISSION("create-submission"){

        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.INCOMPLETE;
        }
    }
    ,
    CREATE_REPLY("create-reply"){

        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.INCOMPLETE;
        }
    }
    ,
    SUBMIT_SUBMISSION("submit-submission"){

        @Override
        public boolean hasAuthTags() {
            return true;
        }

        @Override
        public EventState getState() {
            return EventState.SUBMITTED;
        }
    }
    ,
    SUBMIT_REPLY("submit-reply"){

        @Override
        public boolean hasAuthTags() {
            return true;
        }

        @Override
        public EventState getState() {
            return EventState.SUBMITTED;
        }
    }
    ,
    NOTIFY_SUBMISSION("notify-submission"){

        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.NOTIFIED;
        }
    }
    ,
    NOTIFY_REPLY("notify-reply"){

        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.NOTIFIED;
        }
    }
    ,
    FORWARD_SUBMISSION("forward-submission"){

        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.FORWARDED;
        }
    }
    ,
    ACCEPT_SUBMISSION("accept-submission"){

        @Override
        public boolean hasAuthTags() {
            return true;
        }

        @Override
        public EventState getState() {
            return EventState.ACCEPTED;
        }
    }
    ,
    ACCEPT_REPLY("accept-reply"){

        @Override
        public boolean hasAuthTags() {
            return true;
        }

        @Override
        public EventState getState() {
            return EventState.ACCEPTED;
        }
    }
    ,
    REJECT_SUBMISSION("reject-submission"){

        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.REJECTED;
        }
    }
    ,
    REJECT_REPLY("reject-reply"){

        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.REJECTED;
        }
    }
    ,
    DELETE_SUBMISSION("delete-submission"){

        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.DELETED;
        }
    };

    private static final String EVENTS_SCHEMA_PATH;
    private static final Map<String, Event> CONSTANTS;
    private final String name;

    private Event(String name) {
        this.name = name;
    }

    public static Event fromSchemaUri(String schemaUri) {
        return CONSTANTS.get(schemaUri);
    }

    public String getSchemaUri() {
        return EVENTS_SCHEMA_PATH + this.name;
    }

    public abstract boolean hasAuthTags();

    public abstract EventState getState();

    static {
        EVENTS_SCHEMA_PATH = SchemaConfig.SCHEMA_BASE_URL.getSchemaUri().resolve("events/").toString();
        CONSTANTS = new HashMap<String, Event>();
        for (Event c : Event.values()) {
            CONSTANTS.put(c.getSchemaUri(), c);
        }
    }
}

