/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.destination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Status {
    DRAFT("draft"),
    CREATED("created"),
    ACTIVE("active"),
    INACTIVE("inactive"),
    DECOMMISSIONED("decommissioned");

    private static final Map<String, Status> CONSTANTS;
    private final String value;

    private Status(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @JsonCreator
    public static Status fromValue(String value) {
        Status constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Status>();
        for (Status c : Status.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

