/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.destination;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import dev.fitko.fitconnect.api.domain.model.destination.replychannels.DestinationDeMail;
import dev.fitko.fitconnect.api.domain.model.destination.replychannels.DestinationElster;
import dev.fitko.fitconnect.api.domain.model.destination.replychannels.DestinationEmail;
import dev.fitko.fitconnect.api.domain.model.destination.replychannels.DestinationFink;
import dev.fitko.fitconnect.api.domain.model.destination.replychannels.DestinationFitConnect;
import dev.fitko.fitconnect.api.domain.model.destination.replychannels.DestinationIdBundDeMailbox;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.ReplyChannel;
import java.util.Collection;
import java.util.Objects;
import lombok.Generated;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DestinationReplyChannels {
    private DestinationEmail destinationEmail;
    private DestinationDeMail destinationDeMail;
    private DestinationFink destinationFink;
    private DestinationElster destinationElster;
    private DestinationFitConnect destinationFitConnect;
    private DestinationIdBundDeMailbox destinationIdBundDeMailbox;

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationReplyChannels that = (DestinationReplyChannels)o;
        return Objects.equals(this.destinationEmail, that.destinationEmail) && Objects.equals(this.destinationDeMail != null, that.destinationDeMail != null) && Objects.equals(this.destinationFink != null, that.destinationFink != null) && Objects.equals(this.destinationElster != null, that.destinationElster != null) && Objects.equals(this.destinationIdBundDeMailbox != null, that.destinationIdBundDeMailbox != null) && Objects.equals(this.destinationFitConnect, that.destinationFitConnect);
    }

    public boolean allowsSubmissionReplyChannel(ReplyChannel submissionReplyChannel) {
        if (submissionReplyChannel.isDeMail()) {
            return this.destinationDeMail != null;
        }
        if (submissionReplyChannel.isFink()) {
            return this.destinationFink != null;
        }
        if (submissionReplyChannel.isElster()) {
            return this.destinationElster != null;
        }
        if (submissionReplyChannel.isIdBundDeMailbox()) {
            return this.destinationIdBundDeMailbox != null;
        }
        if (submissionReplyChannel.isEMail()) {
            return this.destinationEmail != null && this.destinationEmail.getUsePgp().equals(submissionReplyChannel.getEmail().getUsePgp());
        }
        if (submissionReplyChannel.isFitConnect()) {
            return this.destinationFitConnect != null && this.destinationFitConnect.getProcessStandards().containsAll(submissionReplyChannel.getFitConnect().getProcessStandards());
        }
        return false;
    }

    @JsonGetter(value="eMail")
    public DestinationEmail getDestinationEmail() {
        return this.destinationEmail;
    }

    @JsonGetter(value="deMail")
    public DestinationDeMail getDestinationDeMail() {
        return this.destinationDeMail;
    }

    @JsonGetter(value="fink")
    public DestinationFink getDestinationFink() {
        return this.destinationFink;
    }

    @JsonGetter(value="elster")
    public DestinationElster getDestinationElster() {
        return this.destinationElster;
    }

    @JsonGetter(value="fitConnect")
    public DestinationFitConnect getDestinationFitConnect() {
        return this.destinationFitConnect;
    }

    @JsonGetter(value="idBundDeMailbox")
    public DestinationIdBundDeMailbox getDestinationIdBundDeMailbox() {
        return this.destinationIdBundDeMailbox;
    }

    @Generated
    public void setDestinationEmail(DestinationEmail destinationEmail) {
        this.destinationEmail = destinationEmail;
    }

    @Generated
    public void setDestinationDeMail(DestinationDeMail destinationDeMail) {
        this.destinationDeMail = destinationDeMail;
    }

    @Generated
    public void setDestinationFink(DestinationFink destinationFink) {
        this.destinationFink = destinationFink;
    }

    @Generated
    public void setDestinationElster(DestinationElster destinationElster) {
        this.destinationElster = destinationElster;
    }

    @Generated
    public void setDestinationFitConnect(DestinationFitConnect destinationFitConnect) {
        this.destinationFitConnect = destinationFitConnect;
    }

    @Generated
    public void setDestinationIdBundDeMailbox(DestinationIdBundDeMailbox destinationIdBundDeMailbox) {
        this.destinationIdBundDeMailbox = destinationIdBundDeMailbox;
    }

    @Generated
    public String toString() {
        return "DestinationReplyChannels(destinationEmail=" + String.valueOf(this.getDestinationEmail()) + ", destinationDeMail=" + String.valueOf(this.getDestinationDeMail()) + ", destinationFink=" + String.valueOf(this.getDestinationFink()) + ", destinationElster=" + String.valueOf(this.getDestinationElster()) + ", destinationFitConnect=" + String.valueOf(this.getDestinationFitConnect()) + ", destinationIdBundDeMailbox=" + String.valueOf(this.getDestinationIdBundDeMailbox()) + ")";
    }

    @Generated
    public DestinationReplyChannels(DestinationEmail destinationEmail, DestinationDeMail destinationDeMail, DestinationFink destinationFink, DestinationElster destinationElster, DestinationFitConnect destinationFitConnect, DestinationIdBundDeMailbox destinationIdBundDeMailbox) {
        this.destinationEmail = destinationEmail;
        this.destinationDeMail = destinationDeMail;
        this.destinationFink = destinationFink;
        this.destinationElster = destinationElster;
        this.destinationFitConnect = destinationFitConnect;
        this.destinationIdBundDeMailbox = destinationIdBundDeMailbox;
    }

    @Generated
    public DestinationReplyChannels() {
    }

    public static class Builder {
        private DestinationEmail destinationEmail;
        private DestinationDeMail destinationDeMail;
        private DestinationFink destinationFink;
        private DestinationElster destinationElster;
        private DestinationFitConnect destinationFitConnect;
        private DestinationIdBundDeMailbox destinationIdBundDeMailbox;

        Builder() {
        }

        public Builder withEmail(boolean usePgp) {
            this.destinationEmail = new DestinationEmail(usePgp);
            return this;
        }

        public Builder withEmail() {
            this.destinationEmail = new DestinationEmail(false);
            return this;
        }

        public Builder withDeMail() {
            this.destinationDeMail = new DestinationDeMail();
            return this;
        }

        public Builder withFink() {
            this.destinationFink = new DestinationFink();
            return this;
        }

        public Builder withElster() {
            this.destinationElster = new DestinationElster();
            return this;
        }

        public Builder withFitConnect(Collection<String> processingStandards) {
            this.destinationFitConnect = new DestinationFitConnect(processingStandards);
            return this;
        }

        public Builder withIdBundDeMailbox(boolean useStatusMonitor) {
            this.destinationIdBundDeMailbox = new DestinationIdBundDeMailbox(useStatusMonitor);
            return this;
        }

        public Builder withIdBundDeMailbox() {
            this.destinationIdBundDeMailbox = new DestinationIdBundDeMailbox(false);
            return this;
        }

        public DestinationReplyChannels build() {
            return new DestinationReplyChannels(this.destinationEmail, this.destinationDeMail, this.destinationFink, this.destinationElster, this.destinationFitConnect, this.destinationIdBundDeMailbox);
        }
    }
}

