/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.attachment;

import dev.fitko.fitconnect.api.domain.model.attachment.Fragment;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.Purpose;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

public class AttachmentPayload {
    private UUID attachmentId;
    private String hashedData;
    private String authTag;
    private String mimeType;
    private String fileName;
    private String description;
    private byte[] data;
    private String dataAsString;
    private Purpose purpose;
    private List<Fragment> fragments;

    public List<UUID> getAllAttachmentIds() {
        if (this.hasFragmentedPayload()) {
            return this.getFragmentIds();
        }
        return List.of(this.attachmentId);
    }

    public List<UUID> getFragmentIds() {
        return this.getFragments().stream().map(Fragment::getFragmentId).collect(Collectors.toList());
    }

    public boolean hasFragmentedPayload() {
        return !this.fragments.isEmpty();
    }

    public Optional<File> getFragmentsBaseFolder() {
        if (this.hasFragmentedPayload()) {
            return Optional.of(this.fragments.get(0).getFile().getParentFile());
        }
        return Optional.empty();
    }

    @Generated
    private static List<Fragment> $default$fragments() {
        return new ArrayList<Fragment>();
    }

    @Generated
    AttachmentPayload(UUID attachmentId, String hashedData, String authTag, String mimeType, String fileName, String description, byte[] data, String dataAsString, Purpose purpose, List<Fragment> fragments) {
        this.attachmentId = attachmentId;
        this.hashedData = hashedData;
        this.authTag = authTag;
        this.mimeType = mimeType;
        this.fileName = fileName;
        this.description = description;
        this.data = data;
        this.dataAsString = dataAsString;
        this.purpose = purpose;
        this.fragments = fragments;
    }

    @Generated
    public static AttachmentPayloadBuilder builder() {
        return new AttachmentPayloadBuilder();
    }

    @Generated
    public AttachmentPayload withAttachmentId(UUID attachmentId) {
        return this.attachmentId == attachmentId ? this : new AttachmentPayload(attachmentId, this.hashedData, this.authTag, this.mimeType, this.fileName, this.description, this.data, this.dataAsString, this.purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withHashedData(String hashedData) {
        return this.hashedData == hashedData ? this : new AttachmentPayload(this.attachmentId, hashedData, this.authTag, this.mimeType, this.fileName, this.description, this.data, this.dataAsString, this.purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withAuthTag(String authTag) {
        return this.authTag == authTag ? this : new AttachmentPayload(this.attachmentId, this.hashedData, authTag, this.mimeType, this.fileName, this.description, this.data, this.dataAsString, this.purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withMimeType(String mimeType) {
        return this.mimeType == mimeType ? this : new AttachmentPayload(this.attachmentId, this.hashedData, this.authTag, mimeType, this.fileName, this.description, this.data, this.dataAsString, this.purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withFileName(String fileName) {
        return this.fileName == fileName ? this : new AttachmentPayload(this.attachmentId, this.hashedData, this.authTag, this.mimeType, fileName, this.description, this.data, this.dataAsString, this.purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withDescription(String description) {
        return this.description == description ? this : new AttachmentPayload(this.attachmentId, this.hashedData, this.authTag, this.mimeType, this.fileName, description, this.data, this.dataAsString, this.purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withData(byte[] data) {
        return this.data == data ? this : new AttachmentPayload(this.attachmentId, this.hashedData, this.authTag, this.mimeType, this.fileName, this.description, data, this.dataAsString, this.purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withDataAsString(String dataAsString) {
        return this.dataAsString == dataAsString ? this : new AttachmentPayload(this.attachmentId, this.hashedData, this.authTag, this.mimeType, this.fileName, this.description, this.data, dataAsString, this.purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withPurpose(Purpose purpose) {
        return this.purpose == purpose ? this : new AttachmentPayload(this.attachmentId, this.hashedData, this.authTag, this.mimeType, this.fileName, this.description, this.data, this.dataAsString, purpose, this.fragments);
    }

    @Generated
    public AttachmentPayload withFragments(List<Fragment> fragments) {
        return this.fragments == fragments ? this : new AttachmentPayload(this.attachmentId, this.hashedData, this.authTag, this.mimeType, this.fileName, this.description, this.data, this.dataAsString, this.purpose, fragments);
    }

    @Generated
    public UUID getAttachmentId() {
        return this.attachmentId;
    }

    @Generated
    public String getHashedData() {
        return this.hashedData;
    }

    @Generated
    public String getAuthTag() {
        return this.authTag;
    }

    @Generated
    public String getMimeType() {
        return this.mimeType;
    }

    @Generated
    public String getFileName() {
        return this.fileName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public byte[] getData() {
        return this.data;
    }

    @Generated
    public String getDataAsString() {
        return this.dataAsString;
    }

    @Generated
    public Purpose getPurpose() {
        return this.purpose;
    }

    @Generated
    public List<Fragment> getFragments() {
        return this.fragments;
    }

    @Generated
    public static class AttachmentPayloadBuilder {
        @Generated
        private UUID attachmentId;
        @Generated
        private String hashedData;
        @Generated
        private String authTag;
        @Generated
        private String mimeType;
        @Generated
        private String fileName;
        @Generated
        private String description;
        @Generated
        private byte[] data;
        @Generated
        private String dataAsString;
        @Generated
        private Purpose purpose;
        @Generated
        private boolean fragments$set;
        @Generated
        private List<Fragment> fragments$value;

        @Generated
        AttachmentPayloadBuilder() {
        }

        @Generated
        public AttachmentPayloadBuilder attachmentId(UUID attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder hashedData(String hashedData) {
            this.hashedData = hashedData;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder authTag(String authTag) {
            this.authTag = authTag;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder data(byte[] data) {
            this.data = data;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder dataAsString(String dataAsString) {
            this.dataAsString = dataAsString;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder purpose(Purpose purpose) {
            this.purpose = purpose;
            return this;
        }

        @Generated
        public AttachmentPayloadBuilder fragments(List<Fragment> fragments) {
            this.fragments$value = fragments;
            this.fragments$set = true;
            return this;
        }

        @Generated
        public AttachmentPayload build() {
            List<Fragment> fragments$value = this.fragments$value;
            if (!this.fragments$set) {
                fragments$value = AttachmentPayload.$default$fragments();
            }
            return new AttachmentPayload(this.attachmentId, this.hashedData, this.authTag, this.mimeType, this.fileName, this.description, this.data, this.dataAsString, this.purpose, fragments$value);
        }

        @Generated
        public String toString() {
            return "AttachmentPayload.AttachmentPayloadBuilder(attachmentId=" + String.valueOf(this.attachmentId) + ", hashedData=" + this.hashedData + ", authTag=" + this.authTag + ", mimeType=" + this.mimeType + ", fileName=" + this.fileName + ", description=" + this.description + ", data=" + Arrays.toString(this.data) + ", dataAsString=" + this.dataAsString + ", purpose=" + String.valueOf((Object)this.purpose) + ", fragments$value=" + String.valueOf(this.fragments$value) + ")";
        }
    }
}

