/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.model.attachment;

import dev.fitko.fitconnect.api.domain.model.metadata.attachment.Purpose;
import dev.fitko.fitconnect.api.domain.model.metadata.data.MimeType;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectAttachmentException;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectSenderException;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;

public final class Attachment {
    private final Path dataFile;
    private final byte[] inMemoryData;
    private UUID attachmentId;
    private final String fileName;
    private final String description;
    private final String mimeType;
    private final Purpose purpose;

    public static Attachment fromPath(Path filePath, String mimeType) throws FitConnectSenderException {
        return Attachment.fromPath(filePath, mimeType, null, null);
    }

    public static Attachment fromPath(Path filePath, String mimeType, String fileName, String description) throws FitConnectSenderException {
        try {
            return new Attachment(Files.readAllBytes(filePath), mimeType, fileName, description, Purpose.ATTACHMENT);
        }
        catch (IOException e) {
            throw new FitConnectSenderException("Reading attachment from path '" + String.valueOf(filePath) + "' failed", e);
        }
    }

    public static Attachment fromInputStream(InputStream inputStream, String mimeType) throws FitConnectSenderException {
        return Attachment.fromInputStream(inputStream, mimeType, null, null);
    }

    public static Attachment fromInputStream(InputStream inputStream, String mimeType, String fileName, String description) throws FitConnectSenderException {
        try {
            return new Attachment(inputStream.readAllBytes(), mimeType, fileName, description, Purpose.ATTACHMENT);
        }
        catch (IOException e) {
            throw new FitConnectSenderException(e.getMessage(), e);
        }
    }

    public static Attachment fromByteArray(byte[] content, String mimeType) {
        return Attachment.fromByteArray(content, mimeType, null, null);
    }

    public static Attachment fromByteArray(byte[] content, String mimeType, String fileName, String description) {
        return new Attachment(content, mimeType, fileName, description, Purpose.ATTACHMENT);
    }

    public static Attachment fromLargeAttachment(Path filePath, String mimeType) throws FitConnectSenderException {
        return Attachment.fromLargeAttachment(filePath, mimeType, null, null);
    }

    public static Attachment fromLargeAttachment(Path filePath, String mimeType, String fileName, String description) throws FitConnectSenderException {
        return new Attachment(filePath, mimeType, fileName, description, Purpose.ATTACHMENT);
    }

    public static Attachment fromLargeAttachment(InputStream inputStream, String mimeType) throws FitConnectSenderException {
        return Attachment.fromLargeAttachment(inputStream, mimeType, null, null);
    }

    public static Attachment fromLargeAttachment(InputStream inputStream, String mimeType, String fileName, String description) throws FitConnectSenderException {
        Path tempFile = Attachment.bufferStreamToFileSystem(inputStream);
        return Attachment.fromLargeAttachment(tempFile, mimeType, fileName, description);
    }

    public static Attachment fromSubmissionData(InputStream inputStream, MimeType mimeType) {
        Path tempFile = Attachment.bufferStreamToFileSystem(inputStream);
        String filename = "data." + mimeType.getExtension();
        return new Attachment(null, null, tempFile, mimeType.value(), filename, "submission data as attachment", Purpose.DATA);
    }

    public static Attachment fromSubmissionData(byte[] data, MimeType mimeType) {
        String filename = "data." + mimeType.getExtension();
        return new Attachment(null, data, null, mimeType.value(), filename, "submission data as attachment", Purpose.DATA);
    }

    public byte[] getDataAsBytes() {
        byte[] byArray;
        if (this.isInMemoryAttachment()) {
            return this.inMemoryData;
        }
        FileInputStream fileInputStream = new FileInputStream(this.dataFile.toFile());
        try {
            byArray = fileInputStream.readAllBytes();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FitConnectSenderException(e.getMessage(), e);
            }
        }
        fileInputStream.close();
        return byArray;
    }

    public InputStream getDataAsInputStream() {
        if (this.isInMemoryAttachment()) {
            return new ByteArrayInputStream(this.inMemoryData);
        }
        try {
            return Files.newInputStream(this.dataFile, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new FitConnectAttachmentException(e.getMessage(), e);
        }
    }

    public String getDataAsString(Charset encoding) {
        return new String(this.getDataAsBytes(), encoding);
    }

    public String getDataAsString() {
        return this.getDataAsString(StandardCharsets.UTF_8);
    }

    public Path getLargeAttachmentFilePath() {
        return this.dataFile;
    }

    public UUID getAttachmentId() {
        return this.attachmentId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Purpose getPurpose() {
        return this.purpose;
    }

    public boolean isInMemoryAttachment() {
        return this.inMemoryData != null && this.dataFile == null;
    }

    public boolean isLargeAttachment() {
        return !this.isInMemoryAttachment();
    }

    private Attachment(byte[] inMemoryData, String mimeType, String fileName, String description, Purpose purpose) {
        this(null, inMemoryData, null, mimeType, fileName, description, purpose);
    }

    private Attachment(Path dataFile, String mimeType, String fileName, String description, Purpose purpose) {
        this(null, null, dataFile, mimeType, fileName, description, purpose);
    }

    public Attachment(UUID attachmentId, byte[] inMemoryData, Path dataFile, String mimeType, String fileName, String description, Purpose purpose) {
        this.inMemoryData = inMemoryData;
        this.dataFile = dataFile;
        this.attachmentId = attachmentId;
        this.fileName = fileName != null ? Attachment.getBaseNameFromPath(fileName) : UUID.randomUUID().toString();
        this.mimeType = mimeType;
        this.description = description;
        this.purpose = purpose;
    }

    private static Path bufferStreamToFileSystem(InputStream inputStream) {
        try {
            Path tempFile = Files.createTempFile("temp_fit_connect_attachment_", ".tmp", new FileAttribute[0]);
            try (FileOutputStream os = new FileOutputStream(tempFile.toFile());){
                inputStream.transferTo(os);
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new FitConnectAttachmentException(e.getMessage(), e);
        }
    }

    private static String getBaseNameFromPath(String fileName) {
        try {
            return Path.of(fileName, new String[0]).getFileName().toString();
        }
        catch (InvalidPathException e) {
            throw new FitConnectSenderException("Reading filename '" + fileName + "' failed ", e);
        }
    }
}

