/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.domain.crypto;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.jwk.JWK;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwk;
import lombok.Generated;

public final class JWKPair {
    private final JWK publicKey;
    private final JWK privateKey;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public ApiJwk getPublicApiJwk() {
        try {
            return (ApiJwk)MAPPER.readValue(this.publicKey.toJSONString(), ApiJwk.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public JWKPair(JWK publicKey, JWK privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    @Generated
    public JWK getPublicKey() {
        return this.publicKey;
    }

    @Generated
    public JWK getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JWKPair)) {
            return false;
        }
        JWKPair other = (JWKPair)o;
        JWK this$publicKey = this.getPublicKey();
        JWK other$publicKey = other.getPublicKey();
        if (this$publicKey == null ? other$publicKey != null : !this$publicKey.equals(other$publicKey)) {
            return false;
        }
        JWK this$privateKey = this.getPrivateKey();
        JWK other$privateKey = other.getPrivateKey();
        return !(this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JWK $publicKey = this.getPublicKey();
        result = result * 59 + ($publicKey == null ? 43 : $publicKey.hashCode());
        JWK $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JWKPair(publicKey=" + String.valueOf(this.getPublicKey()) + ", privateKey=" + String.valueOf(this.getPrivateKey()) + ")";
    }
}

