/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.config.defaults;

import dev.fitko.fitconnect.api.config.Version;
import java.net.URI;

public enum SchemaConfig {
    SCHEMA_BASE_URL(URI.create("https://schema.fitko.de/fit-connect/")),
    ZBP_ADAPTER_SCHEMA(URI.create("https://schema.fitko.de/fit-connect/id.bund.de/message_v6/1.0.0/zbp-message.schema.json"), "/zbp-adapter-schemas/zbp-message-1.0.0.schema.json"),
    SET_SCHEMA_PATH(SchemaConfig.SCHEMA_BASE_URL.schemaUri.resolve("set-payload/"), "/set-payload.schema.json"),
    METADATA_SCHEMA_PATH(SchemaConfig.SCHEMA_BASE_URL.schemaUri.resolve("metadata/"), "/metadata.schema.json"),
    DESTINATION_SCHEMA_VERSION(SchemaConfig.SCHEMA_BASE_URL.schemaUri.resolve("xzufi/destination.schema.json"));

    private final URI schemaUri;
    private final String filename;

    private SchemaConfig(URI schemaUri, String filename) {
        this.schemaUri = schemaUri;
        this.filename = filename;
    }

    private SchemaConfig(URI schemaUri) {
        this.schemaUri = schemaUri;
        this.filename = "";
    }

    public URI getSchemaUriForVersion(Version version) {
        return URI.create(String.valueOf(this.schemaUri) + version.getVersionAsString() + this.filename);
    }

    public URI getSchemaUri() {
        return this.schemaUri;
    }

    public String getFileName() {
        return this.filename;
    }
}

