/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.config.chunking;

public final class ChunkSize {
    private final int size;
    private final Unit unit;

    public ChunkSize(int size) {
        this.size = size;
        this.unit = Unit.MB;
    }

    public static ChunkSize ofMB(int sizeInMB) {
        return new ChunkSize(sizeInMB);
    }

    public int getSizeInBytes() {
        return this.size * this.unit.getSizeInBytes();
    }

    public int getSizeInMB() {
        return this.size;
    }

    private static enum Unit {
        BYTE(1),
        KB(Unit.BYTE.sizeInBytes << 10),
        MB(Unit.KB.sizeInBytes << 10);

        private final int sizeInBytes;

        private Unit(int sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public int getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

