/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.config.chunking;

import dev.fitko.fitconnect.api.config.chunking.ChunkSize;
import java.nio.file.Path;

public class AttachmentChunkingConfig {
    public static final String DEFAULT_ATTACHMENT_FOLDER_NAME = "fit-connect-attachments";
    public static final String TEMP_BUFFERED_FILE_PREFIX = "temp_fit_connect_attachment_";
    private final boolean chunkAllAttachments;
    private final ChunkSize chunkSizeInMB;
    private final String attachmentStoragePath;

    public AttachmentChunkingConfig(boolean chunkAllAttachments, ChunkSize chunkSizeInMB, String attachmentStoragePath) {
        this.chunkAllAttachments = chunkAllAttachments;
        this.chunkSizeInMB = chunkSizeInMB;
        this.attachmentStoragePath = attachmentStoragePath;
    }

    private AttachmentChunkingConfig(boolean chunkAllAttachments, ChunkSize chunkSizeInMB, Path attachmentStoragePath) {
        this(chunkAllAttachments, chunkSizeInMB, attachmentStoragePath == null ? null : attachmentStoragePath.toString());
    }

    public AttachmentChunkingConfig() {
        this(false, null, "");
    }

    public static AttachmentConfigBuilder builder() {
        return new AttachmentConfigBuilder();
    }

    public boolean isChunkAllAttachments() {
        return this.chunkAllAttachments;
    }

    public int getChunkSizeInBytes() {
        return this.chunkSizeInMB.getSizeInBytes();
    }

    public int getChunkSizeInMB() {
        return this.chunkSizeInMB.getSizeInMB();
    }

    public ChunkSize getChunkSizeObject() {
        return this.chunkSizeInMB;
    }

    public Path getAttachmentStoragePath() {
        if (this.attachmentStoragePath == null || this.attachmentStoragePath.isEmpty()) {
            return null;
        }
        return Path.of(this.attachmentStoragePath, new String[0]);
    }

    public static class AttachmentConfigBuilder {
        private boolean chunkAllAttachments;
        private ChunkSize chunkSize;
        private Path attachmentStoragePath;

        AttachmentConfigBuilder() {
        }

        public AttachmentConfigBuilder chunkAllAttachments(boolean chunkAllAttachments) {
            this.chunkAllAttachments = chunkAllAttachments;
            return this;
        }

        public AttachmentConfigBuilder chunkSizeInMB(int sizeInMB) {
            this.chunkSize = ChunkSize.ofMB(sizeInMB);
            return this;
        }

        public AttachmentConfigBuilder attachmentStoragePath(Path attachmentStoragePath) {
            this.attachmentStoragePath = attachmentStoragePath;
            return this;
        }

        public AttachmentChunkingConfig build() {
            return new AttachmentChunkingConfig(this.chunkAllAttachments, this.chunkSize, this.attachmentStoragePath);
        }
    }
}

