/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.config;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.core.utils.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;

public class ZBPCertConfig {
    private final RSAKey clientPrivateKey;
    private final String clientCertificate;
    private final Optional<String> zbpServerCertificate;

    public ZBPCertConfig(Path privateKeyPath, Path clientCertPath) {
        this.clientPrivateKey = this.parseKeyFromPath(privateKeyPath);
        this.clientCertificate = this.readPemStringFromPath(clientCertPath);
        this.zbpServerCertificate = Optional.empty();
    }

    public ZBPCertConfig(String privateKeyAsPem, String clientCertAsPem) {
        this.clientPrivateKey = this.getRsaKeyFromPem(privateKeyAsPem);
        this.clientCertificate = clientCertAsPem;
        this.zbpServerCertificate = Optional.empty();
    }

    public ZBPCertConfig(RSAKey clientPrivateKey, String clientCertificateAsPem, String zbpServerCertificateAsPem) {
        this.clientPrivateKey = clientPrivateKey;
        this.clientCertificate = clientCertificateAsPem;
        this.zbpServerCertificate = Optional.ofNullable(zbpServerCertificateAsPem);
    }

    public boolean hasValidConfiguration() {
        return this.clientPrivateKey != null && Strings.isNotNullOrEmpty(this.clientCertificate);
    }

    private RSAKey parseKeyFromPath(Path privateKeyPath) {
        return this.getRsaKeyFromPem(this.readPemStringFromPath(privateKeyPath));
    }

    private RSAKey getRsaKeyFromPem(String privateKeyPem) {
        try {
            return RSAKey.parseFromPEMEncodedObjects((String)privateKeyPem).toRSAKey();
        }
        catch (JOSEException e) {
            throw new RuntimeException("Could not parse key", e);
        }
    }

    private String readPemStringFromPath(Path pemPath) {
        try {
            return Files.readString(pemPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read pem from path " + String.valueOf(pemPath), e);
        }
    }

    @Generated
    public RSAKey getClientPrivateKey() {
        return this.clientPrivateKey;
    }

    @Generated
    public String getClientCertificate() {
        return this.clientCertificate;
    }

    @Generated
    public Optional<String> getZbpServerCertificate() {
        return this.zbpServerCertificate;
    }
}

