/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.config;

import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;

public final class Version
implements Comparable<Version> {
    public static final char VERSION_SEPARATOR_CHAR = '.';
    public static final String VERSION_SEPARATOR_STRING = "\\.";
    public static final char PRE_RELEASE_SEPARATOR_CHAR = '-';
    private final int major;
    private final int minor;
    private final int patch;
    private final String preRelease;

    public Version(String version) {
        VersionComponents components = this.parseVersion(version);
        this.major = components.major;
        this.minor = components.minor;
        this.patch = components.patch;
        this.preRelease = components.preRelease;
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = null;
    }

    public Version(int major, int minor, int patch, String preRelease) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
    }

    public String getVersionAsString() {
        String baseVersion = this.major + String.valueOf('.') + this.minor + "." + this.patch;
        if (this.preRelease != null) {
            return baseVersion + "-" + this.preRelease;
        }
        return baseVersion;
    }

    public boolean isGreaterThan(Version otherVersion) {
        return this.compareTo(otherVersion) == 1;
    }

    public boolean isGreaterOrEqualThan(Version otherVersion) {
        return this.isGreaterThan(otherVersion) || this.equals(otherVersion);
    }

    private VersionComponents parseVersion(String version) {
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalArgumentException("Version must not be null or empty");
        }
        String trimmedVersion = version.trim();
        String[] parts = trimmedVersion.split(String.valueOf('-'));
        String baseVersion = parts[0];
        String preReleasePart = parts.length > 1 ? parts[1] : null;
        long dotCount = baseVersion.chars().filter(c -> c == 46).count();
        if (dotCount != 2L) {
            throw new IllegalArgumentException("Version " + version + " is not in major.minor.patch format");
        }
        int[] components = Arrays.stream(baseVersion.split(VERSION_SEPARATOR_STRING)).mapToInt(Integer::parseInt).toArray();
        return new VersionComponents(components[0], components[1], components[2], preReleasePart);
    }

    public String toString() {
        return this.getVersionAsString();
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            throw new NullPointerException("Cannot compare with null version");
        }
        int majorComparison = Integer.compare(this.major, other.major);
        if (majorComparison != 0) {
            return majorComparison;
        }
        int minorComparison = Integer.compare(this.minor, other.minor);
        if (minorComparison != 0) {
            return minorComparison;
        }
        int patchComparison = Integer.compare(this.patch, other.patch);
        if (patchComparison != 0) {
            return patchComparison;
        }
        return this.comparePreRelease(this.preRelease, other.preRelease);
    }

    private int comparePreRelease(String thisPreRelease, String otherPreRelease) {
        if (thisPreRelease == null && otherPreRelease == null) {
            return 0;
        }
        if (thisPreRelease == null && otherPreRelease != null) {
            return 1;
        }
        if (thisPreRelease != null && otherPreRelease == null) {
            return -1;
        }
        return thisPreRelease.compareTo(otherPreRelease);
    }

    public boolean equals(Object other) {
        Version otherVersion = (Version)other;
        return this.major == otherVersion.major && this.minor == otherVersion.minor && this.patch == otherVersion.patch && Objects.equals(this.preRelease, otherVersion.preRelease);
    }

    @Generated
    public int getMajor() {
        return this.major;
    }

    @Generated
    public int getMinor() {
        return this.minor;
    }

    @Generated
    public int getPatch() {
        return this.patch;
    }

    @Generated
    public String getPreRelease() {
        return this.preRelease;
    }

    private static final class VersionComponents {
        private final int major;
        private final int minor;
        private final int patch;
        private final String preRelease;

        @Generated
        public VersionComponents(int major, int minor, int patch, String preRelease) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.preRelease = preRelease;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VersionComponents)) {
                return false;
            }
            VersionComponents other = (VersionComponents)o;
            if (this.getMajor() != other.getMajor()) {
                return false;
            }
            if (this.getMinor() != other.getMinor()) {
                return false;
            }
            if (this.getPatch() != other.getPatch()) {
                return false;
            }
            String this$preRelease = this.getPreRelease();
            String other$preRelease = other.getPreRelease();
            return !(this$preRelease == null ? other$preRelease != null : !this$preRelease.equals(other$preRelease));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getMajor();
            result = result * 59 + this.getMinor();
            result = result * 59 + this.getPatch();
            String $preRelease = this.getPreRelease();
            result = result * 59 + ($preRelease == null ? 43 : $preRelease.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Version.VersionComponents(major=" + this.getMajor() + ", minor=" + this.getMinor() + ", patch=" + this.getPatch() + ", preRelease=" + this.getPreRelease() + ")";
        }

        @Generated
        public int getMajor() {
            return this.major;
        }

        @Generated
        public int getMinor() {
            return this.minor;
        }

        @Generated
        public int getPatch() {
            return this.patch;
        }

        @Generated
        public String getPreRelease() {
            return this.preRelease;
        }
    }
}

