/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.config;

import com.nimbusds.jose.jwk.JWK;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class SubscriberConfig {
    private String clientId;
    private String clientSecret;
    private String privateSigningKeyPath;
    private List<String> privateDecryptionKeyPaths;
    private SubscriberKeys subscriberKeys;

    public SubscriberConfig(String clientId, String clientSecret, String privateSigningKeyPath, List<String> privateDecryptionKeyPaths) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.privateSigningKeyPath = privateSigningKeyPath;
        this.privateDecryptionKeyPaths = privateDecryptionKeyPaths;
    }

    private SubscriberConfig(String clientId, String clientSecret, SubscriberKeys subscriberKeys) {
        Objects.requireNonNull(clientId, "clientId must not be null");
        Objects.requireNonNull(clientSecret, "client secret must not be null");
        Objects.requireNonNull(subscriberKeys, "subscriber keys must not be null");
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.subscriberKeys = subscriberKeys;
    }

    public static SubscriberConfigBuilder builder() {
        return new SubscriberConfigBuilder();
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getPrivateSigningKeyPath() {
        return this.privateSigningKeyPath;
    }

    @Generated
    public List<String> getPrivateDecryptionKeyPaths() {
        return this.privateDecryptionKeyPaths;
    }

    @Generated
    public SubscriberKeys getSubscriberKeys() {
        return this.subscriberKeys;
    }

    @Generated
    public SubscriberConfig() {
    }

    public static class SubscriberConfigBuilder {
        private String clientId;
        private String clientSecret;
        private JWK privateSigningKey;
        private List<JWK> privateDecryptionKeys;
        private String privateSigningKeyPath;
        private List<String> privateDecryptionKeyPaths;

        SubscriberConfigBuilder() {
        }

        public SubscriberConfigBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public SubscriberConfigBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        public SubscriberConfigBuilder privateSigningKey(JWK privateSigningKey) {
            this.privateSigningKey = privateSigningKey;
            return this;
        }

        public SubscriberConfigBuilder privateSigningKeyPath(String privateSigningKeyPath) {
            this.privateSigningKeyPath = privateSigningKeyPath;
            return this;
        }

        public SubscriberConfigBuilder privateDecryptionKeys(List<JWK> privateDecryptionKeys) {
            this.privateDecryptionKeys = privateDecryptionKeys;
            return this;
        }

        public SubscriberConfigBuilder privateDecryptionKeyPaths(List<String> privateDecryptionKeyPaths) {
            this.privateDecryptionKeyPaths = privateDecryptionKeyPaths;
            return this;
        }

        public SubscriberConfig build() {
            if (this.privateSigningKey != null && this.privateDecryptionKeys != null) {
                return new SubscriberConfig(this.clientId, this.clientSecret, new SubscriberKeys(this.privateSigningKey, this.privateDecryptionKeys));
            }
            return new SubscriberConfig(this.clientId, this.clientSecret, this.privateSigningKeyPath, this.privateDecryptionKeyPaths);
        }
    }

    public static class SubscriberKeys {
        private JWK privateSigningKey;
        private List<JWK> privateDecryptionKeys;

        @Generated
        public JWK getPrivateSigningKey() {
            return this.privateSigningKey;
        }

        @Generated
        public List<JWK> getPrivateDecryptionKeys() {
            return this.privateDecryptionKeys;
        }

        @Generated
        public SubscriberKeys(JWK privateSigningKey, List<JWK> privateDecryptionKeys) {
            this.privateSigningKey = privateSigningKey;
            this.privateDecryptionKeys = privateDecryptionKeys;
        }
    }
}

