/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.config;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class Environment {
    private String authBaseUrl;
    private String routingBaseUrl;
    private List<String> submissionBaseUrls = Collections.emptyList();
    private String selfServicePortalBaseUrl;
    private String destinationBaseUrl;
    private Boolean enableAutoReject;
    private Boolean allowInsecurePublicKey;
    private Boolean skipSubmissionDataValidation;

    public Environment merge(Environment other) {
        Environment mergedEnv = new Environment();
        mergedEnv.setAuthBaseUrl(Environment.ofNullOrEmpty(this.authBaseUrl).orElse(other.getAuthBaseUrl()));
        mergedEnv.setRoutingBaseUrl(Environment.ofNullOrEmpty(this.routingBaseUrl).orElse(other.getRoutingBaseUrl()));
        mergedEnv.setSubmissionBaseUrls(Environment.ofNullOrEmpty(this.submissionBaseUrls).orElse(other.getSubmissionBaseUrls()));
        mergedEnv.setSelfServicePortalBaseUrl(Environment.ofNullOrEmpty(this.selfServicePortalBaseUrl).orElse(other.getSelfServicePortalBaseUrl()));
        mergedEnv.setDestinationBaseUrl(Environment.ofNullOrEmpty(this.destinationBaseUrl).orElse(other.getDestinationBaseUrl()));
        mergedEnv.setEnableAutoReject(Optional.ofNullable(this.enableAutoReject).orElse(other.getEnableAutoReject()));
        mergedEnv.setAllowInsecurePublicKey(Optional.ofNullable(this.allowInsecurePublicKey).orElse(other.getAllowInsecurePublicKey()));
        mergedEnv.setSkipSubmissionDataValidation(Optional.ofNullable(this.skipSubmissionDataValidation).orElse(other.getSkipSubmissionDataValidation()));
        return mergedEnv;
    }

    private static Optional<String> ofNullOrEmpty(String s) {
        return s == null || s.isEmpty() ? Optional.empty() : Optional.of(s);
    }

    private static Optional<List<String>> ofNullOrEmpty(List<String> list) {
        return list == null || list.isEmpty() ? Optional.empty() : Optional.of(list);
    }

    @Generated
    public String getAuthBaseUrl() {
        return this.authBaseUrl;
    }

    @Generated
    public String getRoutingBaseUrl() {
        return this.routingBaseUrl;
    }

    @Generated
    public List<String> getSubmissionBaseUrls() {
        return this.submissionBaseUrls;
    }

    @Generated
    public String getSelfServicePortalBaseUrl() {
        return this.selfServicePortalBaseUrl;
    }

    @Generated
    public String getDestinationBaseUrl() {
        return this.destinationBaseUrl;
    }

    @Generated
    public Boolean getEnableAutoReject() {
        return this.enableAutoReject;
    }

    @Generated
    public Boolean getAllowInsecurePublicKey() {
        return this.allowInsecurePublicKey;
    }

    @Generated
    public Boolean getSkipSubmissionDataValidation() {
        return this.skipSubmissionDataValidation;
    }

    @Generated
    public void setAuthBaseUrl(String authBaseUrl) {
        this.authBaseUrl = authBaseUrl;
    }

    @Generated
    public void setRoutingBaseUrl(String routingBaseUrl) {
        this.routingBaseUrl = routingBaseUrl;
    }

    @Generated
    public void setSubmissionBaseUrls(List<String> submissionBaseUrls) {
        this.submissionBaseUrls = submissionBaseUrls;
    }

    @Generated
    public void setSelfServicePortalBaseUrl(String selfServicePortalBaseUrl) {
        this.selfServicePortalBaseUrl = selfServicePortalBaseUrl;
    }

    @Generated
    public void setDestinationBaseUrl(String destinationBaseUrl) {
        this.destinationBaseUrl = destinationBaseUrl;
    }

    @Generated
    public void setEnableAutoReject(Boolean enableAutoReject) {
        this.enableAutoReject = enableAutoReject;
    }

    @Generated
    public void setAllowInsecurePublicKey(Boolean allowInsecurePublicKey) {
        this.allowInsecurePublicKey = allowInsecurePublicKey;
    }

    @Generated
    public void setSkipSubmissionDataValidation(Boolean skipSubmissionDataValidation) {
        this.skipSubmissionDataValidation = skipSubmissionDataValidation;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enableAutoReject = this.getEnableAutoReject();
        Boolean other$enableAutoReject = other.getEnableAutoReject();
        if (this$enableAutoReject == null ? other$enableAutoReject != null : !((Object)this$enableAutoReject).equals(other$enableAutoReject)) {
            return false;
        }
        Boolean this$allowInsecurePublicKey = this.getAllowInsecurePublicKey();
        Boolean other$allowInsecurePublicKey = other.getAllowInsecurePublicKey();
        if (this$allowInsecurePublicKey == null ? other$allowInsecurePublicKey != null : !((Object)this$allowInsecurePublicKey).equals(other$allowInsecurePublicKey)) {
            return false;
        }
        Boolean this$skipSubmissionDataValidation = this.getSkipSubmissionDataValidation();
        Boolean other$skipSubmissionDataValidation = other.getSkipSubmissionDataValidation();
        if (this$skipSubmissionDataValidation == null ? other$skipSubmissionDataValidation != null : !((Object)this$skipSubmissionDataValidation).equals(other$skipSubmissionDataValidation)) {
            return false;
        }
        String this$authBaseUrl = this.getAuthBaseUrl();
        String other$authBaseUrl = other.getAuthBaseUrl();
        if (this$authBaseUrl == null ? other$authBaseUrl != null : !this$authBaseUrl.equals(other$authBaseUrl)) {
            return false;
        }
        String this$routingBaseUrl = this.getRoutingBaseUrl();
        String other$routingBaseUrl = other.getRoutingBaseUrl();
        if (this$routingBaseUrl == null ? other$routingBaseUrl != null : !this$routingBaseUrl.equals(other$routingBaseUrl)) {
            return false;
        }
        List<String> this$submissionBaseUrls = this.getSubmissionBaseUrls();
        List<String> other$submissionBaseUrls = other.getSubmissionBaseUrls();
        if (this$submissionBaseUrls == null ? other$submissionBaseUrls != null : !((Object)this$submissionBaseUrls).equals(other$submissionBaseUrls)) {
            return false;
        }
        String this$selfServicePortalBaseUrl = this.getSelfServicePortalBaseUrl();
        String other$selfServicePortalBaseUrl = other.getSelfServicePortalBaseUrl();
        if (this$selfServicePortalBaseUrl == null ? other$selfServicePortalBaseUrl != null : !this$selfServicePortalBaseUrl.equals(other$selfServicePortalBaseUrl)) {
            return false;
        }
        String this$destinationBaseUrl = this.getDestinationBaseUrl();
        String other$destinationBaseUrl = other.getDestinationBaseUrl();
        return !(this$destinationBaseUrl == null ? other$destinationBaseUrl != null : !this$destinationBaseUrl.equals(other$destinationBaseUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Environment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enableAutoReject = this.getEnableAutoReject();
        result = result * 59 + ($enableAutoReject == null ? 43 : ((Object)$enableAutoReject).hashCode());
        Boolean $allowInsecurePublicKey = this.getAllowInsecurePublicKey();
        result = result * 59 + ($allowInsecurePublicKey == null ? 43 : ((Object)$allowInsecurePublicKey).hashCode());
        Boolean $skipSubmissionDataValidation = this.getSkipSubmissionDataValidation();
        result = result * 59 + ($skipSubmissionDataValidation == null ? 43 : ((Object)$skipSubmissionDataValidation).hashCode());
        String $authBaseUrl = this.getAuthBaseUrl();
        result = result * 59 + ($authBaseUrl == null ? 43 : $authBaseUrl.hashCode());
        String $routingBaseUrl = this.getRoutingBaseUrl();
        result = result * 59 + ($routingBaseUrl == null ? 43 : $routingBaseUrl.hashCode());
        List<String> $submissionBaseUrls = this.getSubmissionBaseUrls();
        result = result * 59 + ($submissionBaseUrls == null ? 43 : ((Object)$submissionBaseUrls).hashCode());
        String $selfServicePortalBaseUrl = this.getSelfServicePortalBaseUrl();
        result = result * 59 + ($selfServicePortalBaseUrl == null ? 43 : $selfServicePortalBaseUrl.hashCode());
        String $destinationBaseUrl = this.getDestinationBaseUrl();
        result = result * 59 + ($destinationBaseUrl == null ? 43 : $destinationBaseUrl.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Environment(authBaseUrl=" + this.getAuthBaseUrl() + ", routingBaseUrl=" + this.getRoutingBaseUrl() + ", submissionBaseUrls=" + String.valueOf(this.getSubmissionBaseUrls()) + ", selfServicePortalBaseUrl=" + this.getSelfServicePortalBaseUrl() + ", destinationBaseUrl=" + this.getDestinationBaseUrl() + ", enableAutoReject=" + this.getEnableAutoReject() + ", allowInsecurePublicKey=" + this.getAllowInsecurePublicKey() + ", skipSubmissionDataValidation=" + this.getSkipSubmissionDataValidation() + ")";
    }

    @Generated
    public Environment(String authBaseUrl, String routingBaseUrl, List<String> submissionBaseUrls, String selfServicePortalBaseUrl, String destinationBaseUrl, Boolean enableAutoReject, Boolean allowInsecurePublicKey, Boolean skipSubmissionDataValidation) {
        this.authBaseUrl = authBaseUrl;
        this.routingBaseUrl = routingBaseUrl;
        this.submissionBaseUrls = submissionBaseUrls;
        this.selfServicePortalBaseUrl = selfServicePortalBaseUrl;
        this.destinationBaseUrl = destinationBaseUrl;
        this.enableAutoReject = enableAutoReject;
        this.allowInsecurePublicKey = allowInsecurePublicKey;
        this.skipSubmissionDataValidation = skipSubmissionDataValidation;
    }

    @Generated
    public Environment() {
    }
}

