/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api.config;

import dev.fitko.fitconnect.api.config.Environment;
import dev.fitko.fitconnect.api.config.EnvironmentName;
import dev.fitko.fitconnect.api.config.SenderConfig;
import dev.fitko.fitconnect.api.config.SubscriberConfig;
import dev.fitko.fitconnect.api.config.Version;
import dev.fitko.fitconnect.api.config.chunking.AttachmentChunkingConfig;
import dev.fitko.fitconnect.api.config.defaults.Environments;
import dev.fitko.fitconnect.api.config.defaults.SchemaConfig;
import dev.fitko.fitconnect.api.config.http.HttpConfig;
import dev.fitko.fitconnect.api.config.virusscan.VirusScannerConfig;
import dev.fitko.fitconnect.api.config.virusscan.VirusScannerMode;
import dev.fitko.fitconnect.api.exceptions.client.FitConnectInitialisationException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;

public class ApplicationConfig {
    public static final Version SET_SCHEMA_WRITE_VERSION = new Version("1.2.2");
    public static final Version METADATA_SCHEMA_V1_WRITE_VERSION = new Version("1.5.0");
    public static final Version METADATA_SCHEMA_V2_WRITE_VERSION = new Version("2.0.0");
    public static final Version MIN_METADATA_VERSION_WITH_CHUNKING_SUPPORT = new Version("1.3.0");
    public static final int MAX_DATA_SIZE_IN_BYTE = 0xD00000;
    public static final Pattern LEIKA_KEY_PATTERN = Pattern.compile("^urn:[a-z0-9][a-z0-9-]{0,31}:[a-z0-9()+,.:=@;$_!*'%/?#-]+$");
    private SenderConfig senderConfig;
    private SubscriberConfig subscriberConfig;
    private EnvironmentName activeEnvironment;
    private HttpConfig httpConfig;
    private AttachmentChunkingConfig attachmentChunkingConfig;
    private Map<String, String> submissionDataSchemas;
    private int concurrentAttachmentStreams;
    private VirusScannerConfig virusScannerConfig;
    private VirusScannerMode virusScannerMode;
    private Map<EnvironmentName, Environment> environments;

    public boolean isAutoRejectEnabled() {
        return this.getCurrentEnvironment().getEnableAutoReject();
    }

    public boolean isSkipSubmissionDataValidation() {
        return this.getCurrentEnvironment().getSkipSubmissionDataValidation();
    }

    public boolean isAllowInsecurePublicKey() {
        return this.getCurrentEnvironment().getAllowInsecurePublicKey();
    }

    public String getSubmissionBaseUrl() {
        return (String)this.getCurrentEnvironment().getSubmissionBaseUrls().stream().findFirst().orElseThrow(() -> new FitConnectInitialisationException("No submission base url found, expected at least one"));
    }

    public String getDestinationBaseUrl() {
        return this.getCurrentEnvironment().getDestinationBaseUrl();
    }

    public String getSelfServicePortalBaseUrl() {
        return this.getCurrentEnvironment().getSelfServicePortalBaseUrl();
    }

    public String getRoutingBaseUrl() {
        return this.getCurrentEnvironment().getRoutingBaseUrl();
    }

    public String getAuthBaseUrl() {
        return this.getCurrentEnvironment().getAuthBaseUrl();
    }

    public URI getSetSchemaWriteVersion() {
        return SchemaConfig.SET_SCHEMA_PATH.getSchemaUriForVersion(SET_SCHEMA_WRITE_VERSION);
    }

    public URI getMetadataSchemaWriteVersion() {
        return SchemaConfig.METADATA_SCHEMA_PATH.getSchemaUriForVersion(METADATA_SCHEMA_V1_WRITE_VERSION);
    }

    public URI getDestinationSchemaUri() {
        return SchemaConfig.DESTINATION_SCHEMA_VERSION.getSchemaUri();
    }

    public Environment getCurrentEnvironment() {
        if (this.activeEnvironment == null) {
            throw new FitConnectInitialisationException("Environment must not be null. Please set active environment. Available environments are: " + Environments.getAvailableEnvironmentNames());
        }
        if (!this.environments.containsKey(this.activeEnvironment)) {
            throw new FitConnectInitialisationException("Environment '" + this.activeEnvironment.getName() + "' not found. Available environments are: " + Environments.getAvailableEnvironmentNames());
        }
        return this.environments.get(this.activeEnvironment);
    }

    @Generated
    private static HttpConfig $default$httpConfig() {
        return new HttpConfig();
    }

    @Generated
    private static AttachmentChunkingConfig $default$attachmentChunkingConfig() {
        return new AttachmentChunkingConfig();
    }

    @Generated
    private static Map<String, String> $default$submissionDataSchemas() {
        return new HashMap<String, String>();
    }

    @Generated
    private static int $default$concurrentAttachmentStreams() {
        return 3;
    }

    @Generated
    private static VirusScannerConfig $default$virusScannerConfig() {
        return VirusScannerConfig.defaultConfig();
    }

    @Generated
    private static VirusScannerMode $default$virusScannerMode() {
        return VirusScannerMode.NO_OP;
    }

    @Generated
    private static Map<EnvironmentName, Environment> $default$environments() {
        return Environments.getEnvironmentsAsMap();
    }

    @Generated
    public static ApplicationConfigBuilder builder() {
        return new ApplicationConfigBuilder();
    }

    @Generated
    public SenderConfig getSenderConfig() {
        return this.senderConfig;
    }

    @Generated
    public SubscriberConfig getSubscriberConfig() {
        return this.subscriberConfig;
    }

    @Generated
    public EnvironmentName getActiveEnvironment() {
        return this.activeEnvironment;
    }

    @Generated
    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    @Generated
    public AttachmentChunkingConfig getAttachmentChunkingConfig() {
        return this.attachmentChunkingConfig;
    }

    @Generated
    public Map<String, String> getSubmissionDataSchemas() {
        return this.submissionDataSchemas;
    }

    @Generated
    public int getConcurrentAttachmentStreams() {
        return this.concurrentAttachmentStreams;
    }

    @Generated
    public VirusScannerConfig getVirusScannerConfig() {
        return this.virusScannerConfig;
    }

    @Generated
    public VirusScannerMode getVirusScannerMode() {
        return this.virusScannerMode;
    }

    @Generated
    public Map<EnvironmentName, Environment> getEnvironments() {
        return this.environments;
    }

    @Generated
    public String toString() {
        return "ApplicationConfig(senderConfig=" + String.valueOf(this.getSenderConfig()) + ", subscriberConfig=" + String.valueOf(this.getSubscriberConfig()) + ", activeEnvironment=" + String.valueOf(this.getActiveEnvironment()) + ", httpConfig=" + String.valueOf(this.getHttpConfig()) + ", attachmentChunkingConfig=" + String.valueOf(this.getAttachmentChunkingConfig()) + ", submissionDataSchemas=" + String.valueOf(this.getSubmissionDataSchemas()) + ", concurrentAttachmentStreams=" + this.getConcurrentAttachmentStreams() + ", virusScannerConfig=" + String.valueOf(this.getVirusScannerConfig()) + ", virusScannerMode=" + String.valueOf((Object)this.getVirusScannerMode()) + ", environments=" + String.valueOf(this.getEnvironments()) + ")";
    }

    @Generated
    public ApplicationConfig() {
        this.httpConfig = ApplicationConfig.$default$httpConfig();
        this.attachmentChunkingConfig = ApplicationConfig.$default$attachmentChunkingConfig();
        this.submissionDataSchemas = ApplicationConfig.$default$submissionDataSchemas();
        this.concurrentAttachmentStreams = ApplicationConfig.$default$concurrentAttachmentStreams();
        this.virusScannerConfig = ApplicationConfig.$default$virusScannerConfig();
        this.virusScannerMode = ApplicationConfig.$default$virusScannerMode();
        this.environments = ApplicationConfig.$default$environments();
    }

    @Generated
    public ApplicationConfig(SenderConfig senderConfig, SubscriberConfig subscriberConfig, EnvironmentName activeEnvironment, HttpConfig httpConfig, AttachmentChunkingConfig attachmentChunkingConfig, Map<String, String> submissionDataSchemas, int concurrentAttachmentStreams, VirusScannerConfig virusScannerConfig, VirusScannerMode virusScannerMode, Map<EnvironmentName, Environment> environments) {
        this.senderConfig = senderConfig;
        this.subscriberConfig = subscriberConfig;
        this.activeEnvironment = activeEnvironment;
        this.httpConfig = httpConfig;
        this.attachmentChunkingConfig = attachmentChunkingConfig;
        this.submissionDataSchemas = submissionDataSchemas;
        this.concurrentAttachmentStreams = concurrentAttachmentStreams;
        this.virusScannerConfig = virusScannerConfig;
        this.virusScannerMode = virusScannerMode;
        this.environments = environments;
    }

    @Generated
    public ApplicationConfig withEnvironments(Map<EnvironmentName, Environment> environments) {
        return this.environments == environments ? this : new ApplicationConfig(this.senderConfig, this.subscriberConfig, this.activeEnvironment, this.httpConfig, this.attachmentChunkingConfig, this.submissionDataSchemas, this.concurrentAttachmentStreams, this.virusScannerConfig, this.virusScannerMode, environments);
    }

    @Generated
    public static class ApplicationConfigBuilder {
        @Generated
        private SenderConfig senderConfig;
        @Generated
        private SubscriberConfig subscriberConfig;
        @Generated
        private EnvironmentName activeEnvironment;
        @Generated
        private boolean httpConfig$set;
        @Generated
        private HttpConfig httpConfig$value;
        @Generated
        private boolean attachmentChunkingConfig$set;
        @Generated
        private AttachmentChunkingConfig attachmentChunkingConfig$value;
        @Generated
        private boolean submissionDataSchemas$set;
        @Generated
        private Map<String, String> submissionDataSchemas$value;
        @Generated
        private boolean concurrentAttachmentStreams$set;
        @Generated
        private int concurrentAttachmentStreams$value;
        @Generated
        private boolean virusScannerConfig$set;
        @Generated
        private VirusScannerConfig virusScannerConfig$value;
        @Generated
        private boolean virusScannerMode$set;
        @Generated
        private VirusScannerMode virusScannerMode$value;
        @Generated
        private boolean environments$set;
        @Generated
        private Map<EnvironmentName, Environment> environments$value;

        @Generated
        ApplicationConfigBuilder() {
        }

        @Generated
        public ApplicationConfigBuilder senderConfig(SenderConfig senderConfig) {
            this.senderConfig = senderConfig;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder subscriberConfig(SubscriberConfig subscriberConfig) {
            this.subscriberConfig = subscriberConfig;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder activeEnvironment(EnvironmentName activeEnvironment) {
            this.activeEnvironment = activeEnvironment;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder httpConfig(HttpConfig httpConfig) {
            this.httpConfig$value = httpConfig;
            this.httpConfig$set = true;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder attachmentChunkingConfig(AttachmentChunkingConfig attachmentChunkingConfig) {
            this.attachmentChunkingConfig$value = attachmentChunkingConfig;
            this.attachmentChunkingConfig$set = true;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder submissionDataSchemas(Map<String, String> submissionDataSchemas) {
            this.submissionDataSchemas$value = submissionDataSchemas;
            this.submissionDataSchemas$set = true;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder concurrentAttachmentStreams(int concurrentAttachmentStreams) {
            this.concurrentAttachmentStreams$value = concurrentAttachmentStreams;
            this.concurrentAttachmentStreams$set = true;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder virusScannerConfig(VirusScannerConfig virusScannerConfig) {
            this.virusScannerConfig$value = virusScannerConfig;
            this.virusScannerConfig$set = true;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder virusScannerMode(VirusScannerMode virusScannerMode) {
            this.virusScannerMode$value = virusScannerMode;
            this.virusScannerMode$set = true;
            return this;
        }

        @Generated
        public ApplicationConfigBuilder environments(Map<EnvironmentName, Environment> environments) {
            this.environments$value = environments;
            this.environments$set = true;
            return this;
        }

        @Generated
        public ApplicationConfig build() {
            HttpConfig httpConfig$value = this.httpConfig$value;
            if (!this.httpConfig$set) {
                httpConfig$value = ApplicationConfig.$default$httpConfig();
            }
            AttachmentChunkingConfig attachmentChunkingConfig$value = this.attachmentChunkingConfig$value;
            if (!this.attachmentChunkingConfig$set) {
                attachmentChunkingConfig$value = ApplicationConfig.$default$attachmentChunkingConfig();
            }
            Map<String, String> submissionDataSchemas$value = this.submissionDataSchemas$value;
            if (!this.submissionDataSchemas$set) {
                submissionDataSchemas$value = ApplicationConfig.$default$submissionDataSchemas();
            }
            int concurrentAttachmentStreams$value = this.concurrentAttachmentStreams$value;
            if (!this.concurrentAttachmentStreams$set) {
                concurrentAttachmentStreams$value = ApplicationConfig.$default$concurrentAttachmentStreams();
            }
            VirusScannerConfig virusScannerConfig$value = this.virusScannerConfig$value;
            if (!this.virusScannerConfig$set) {
                virusScannerConfig$value = ApplicationConfig.$default$virusScannerConfig();
            }
            VirusScannerMode virusScannerMode$value = this.virusScannerMode$value;
            if (!this.virusScannerMode$set) {
                virusScannerMode$value = ApplicationConfig.$default$virusScannerMode();
            }
            Map<EnvironmentName, Environment> environments$value = this.environments$value;
            if (!this.environments$set) {
                environments$value = ApplicationConfig.$default$environments();
            }
            return new ApplicationConfig(this.senderConfig, this.subscriberConfig, this.activeEnvironment, httpConfig$value, attachmentChunkingConfig$value, submissionDataSchemas$value, concurrentAttachmentStreams$value, virusScannerConfig$value, virusScannerMode$value, environments$value);
        }

        @Generated
        public String toString() {
            return "ApplicationConfig.ApplicationConfigBuilder(senderConfig=" + String.valueOf(this.senderConfig) + ", subscriberConfig=" + String.valueOf(this.subscriberConfig) + ", activeEnvironment=" + String.valueOf(this.activeEnvironment) + ", httpConfig$value=" + String.valueOf(this.httpConfig$value) + ", attachmentChunkingConfig$value=" + String.valueOf(this.attachmentChunkingConfig$value) + ", submissionDataSchemas$value=" + String.valueOf(this.submissionDataSchemas$value) + ", concurrentAttachmentStreams$value=" + this.concurrentAttachmentStreams$value + ", virusScannerConfig$value=" + String.valueOf(this.virusScannerConfig$value) + ", virusScannerMode$value=" + String.valueOf((Object)this.virusScannerMode$value) + ", environments$value=" + String.valueOf(this.environments$value) + ")";
        }
    }
}

