/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.api;

import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.api.domain.limits.submission.SubmissionLimits;
import dev.fitko.fitconnect.api.domain.model.cases.Case;
import dev.fitko.fitconnect.api.domain.model.cases.Cases;
import dev.fitko.fitconnect.api.domain.model.destination.Destination;
import dev.fitko.fitconnect.api.domain.model.destination.PublicDestination;
import dev.fitko.fitconnect.api.domain.model.event.EventLogEntry;
import dev.fitko.fitconnect.api.domain.model.event.EventPayload;
import dev.fitko.fitconnect.api.domain.model.event.Status;
import dev.fitko.fitconnect.api.domain.model.event.authtags.AuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.authtags.ValidatedAuthenticationTags;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import dev.fitko.fitconnect.api.domain.model.metadata.Metadata;
import dev.fitko.fitconnect.api.domain.model.metadata.attachment.AttachmentForValidation;
import dev.fitko.fitconnect.api.domain.model.reply.AcceptReply;
import dev.fitko.fitconnect.api.domain.model.reply.AnnounceReply;
import dev.fitko.fitconnect.api.domain.model.reply.CreatedReply;
import dev.fitko.fitconnect.api.domain.model.reply.RepliesForPickup;
import dev.fitko.fitconnect.api.domain.model.reply.Reply;
import dev.fitko.fitconnect.api.domain.model.reply.SentReply;
import dev.fitko.fitconnect.api.domain.model.reply.SubmitReply;
import dev.fitko.fitconnect.api.domain.model.submission.AnnounceSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.CreatedSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.SentSubmission;
import dev.fitko.fitconnect.api.domain.model.submission.Submission;
import dev.fitko.fitconnect.api.domain.model.submission.SubmissionsForPickup;
import dev.fitko.fitconnect.api.domain.model.submission.SubmitSubmission;
import dev.fitko.fitconnect.api.domain.validation.ValidationResult;
import dev.fitko.fitconnect.api.domain.validation.VirusScanResult;
import dev.fitko.fitconnect.api.exceptions.internal.DecryptionException;
import dev.fitko.fitconnect.api.exceptions.internal.EncryptionException;
import dev.fitko.fitconnect.api.exceptions.internal.EventLogException;
import dev.fitko.fitconnect.api.exceptions.internal.RestApiException;
import dev.fitko.fitconnect.api.exceptions.internal.VirusScanException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;

public interface FitConnectService {
    public ValidationResult validateMetadataSchema(Metadata var1);

    public ValidationResult validateSubmissionMetadata(Metadata var1, Submission var2, AuthenticationTags var3);

    public ValidationResult validateJsonSchema(byte[] var1, URI var2);

    public ValidationResult validateXmlSchema(byte[] var1, URI var2);

    public ValidationResult validateJsonFormat(byte[] var1);

    public ValidationResult validateXmlFormat(byte[] var1);

    public ValidationResult validateCallback(String var1, Long var2, String var3, String var4);

    public ValidationResult validateAttachments(List<AttachmentForValidation> var1, AuthenticationTags var2);

    public ValidationResult validateReplyMetadata(Metadata var1, Reply var2, AuthenticationTags var3);

    public ValidationResult validateData(byte[] var1, String var2, Metadata var3, String var4);

    public String encryptBytes(RSAKey var1, byte[] var2, String var3) throws EncryptionException;

    public JWEObject encryptInputStream(RSAKey var1, InputStream var2, String var3) throws EncryptionException;

    public String encryptObject(RSAKey var1, Object var2, String var3) throws EncryptionException;

    public byte[] decryptString(RSAKey var1, String var2) throws DecryptionException;

    public String createHash(byte[] var1);

    public String createHash(InputStream var1);

    public SubmissionsForPickup getAvailableSubmissions(UUID var1, int var2, int var3) throws RestApiException;

    public CreatedSubmission announceSubmission(AnnounceSubmission var1);

    public Submission sendSubmission(SubmitSubmission var1);

    public void uploadSubmissionAttachment(UUID var1, UUID var2, String var3);

    public Submission getSubmission(UUID var1) throws RestApiException;

    public void uploadSubmissionAttachmentStream(UUID var1, UUID var2, InputStream var3) throws RestApiException;

    public String getSubmissionAttachment(UUID var1, UUID var2) throws RestApiException;

    public SubmissionLimits getDestinationAttachmentLimits(UUID var1) throws RestApiException;

    public SubmissionLimits getCaseAttachmentLimits(UUID var1) throws RestApiException;

    public void acceptSubmission(EventPayload var1) throws RestApiException;

    public void rejectSubmission(EventPayload var1) throws RestApiException;

    public PublicDestination getPublicDestination(UUID var1);

    public Destination getPrivateDestination(UUID var1);

    public RSAKey getEncryptionKeyForDestination(UUID var1);

    public RSAKey getEncryptionKeyForDestination(PublicDestination var1);

    public Status getStatus(SentSubmission var1) throws RestApiException;

    public Status getStatus(SentReply var1) throws RestApiException;

    public List<EventLogEntry> getEventLogForCase(UUID var1, UUID var2, AuthenticationTags var3);

    public List<EventLogEntry> getEventLogForSubmission(UUID var1, UUID var2, UUID var3, AuthenticationTags var4);

    public ValidatedAuthenticationTags getSubmissionAuthenticationTags(Submission var1) throws RestApiException;

    public ValidatedAuthenticationTags getReplyAuthenticationTags(Reply var1) throws RestApiException, EventLogException;

    public Cases listCases(int var1, int var2) throws RestApiException, EventLogException;

    public Case getCase(UUID var1) throws RestApiException, EventLogException;

    public Reply getReply(UUID var1) throws RestApiException;

    public RepliesForPickup getAvailableReplies(int var1, int var2) throws RestApiException;

    public void uploadReplyAttachment(UUID var1, UUID var2, String var3) throws RestApiException;

    public String getReplyAttachment(UUID var1, UUID var2) throws RestApiException;

    public SentReply submitReply(UUID var1, SubmitReply var2) throws RestApiException;

    public CreatedReply announceReply(AnnounceReply var1) throws RestApiException;

    public String acceptReply(UUID var1, AcceptReply var2) throws RestApiException;

    public String rejectReply(UUID var1, List<Problem> var2) throws RestApiException;

    public Status getSubmitState(Submission var1);

    public VirusScanResult scanBytesForViruses(byte[] var1) throws VirusScanException;

    public VirusScanResult scanStreamForViruses(InputStream var1) throws VirusScanException;

    public VirusScanResult scanFileForViruses(Path var1) throws VirusScanException;
}

