package dev.fitko.fitconnect.core.validation.virusscan.process;

import lombok.Builder;
import lombok.Data;

/** Configuration for ClamAV process scanner settings. */
@Data
@Builder
public class ClamAVProcessConfig {

    /**
     * Path to the ClamAV executable (e.g., "clamscan", "/usr/bin/clamscan", or "C:\\Program
     * Files\\ClamAV\\clamscan.exe").
     */
    @Builder.Default
    private String executablePath = "clamscan";

    /**
     * Custom temporary directory path to use for scanning. If no temp dir is specified,
     * "java.io.tmpdir" is used. This can be used to specify a directory that's excluded from
     * antivirus scanning.
     */
    @Builder.Default
    private String tempDirectory = System.getProperty("java.io.tmpdir");

    /** Creates default configuration. */
    public static ClamAVProcessConfig defaultConfig() {
        return ClamAVProcessConfig.builder().build();
    }

    /** Creates configuration with custom executable path. */
    public static ClamAVProcessConfig of(String executablePath) {
        return ClamAVProcessConfig.builder().executablePath(executablePath).build();
    }

    /** Creates configuration with custom executable path and temp dir. */
    public static ClamAVProcessConfig of(String executablePath, String tempDir) {
        return ClamAVProcessConfig.builder()
                .executablePath(executablePath)
                .tempDirectory(tempDir)
                .build();
    }
}
