package dev.fitko.fitconnect.core.validation.virusscan.deamon.response;

/** Enum representing the different response types from ClamAV. */
public enum ClamAVStreamResponse {

    /** Response indicating no virus was found. */
    OK("OK"),

    /** Response indicating a virus was found. */
    FOUND("FOUND"),

    /** Response indicating an error occurred during scanning. */
    ERROR("ERROR"),

    /** Response prefix for stream scanning. */
    STREAM_PREFIX("stream:");

    private final String value;

    ClamAVStreamResponse(String value) {
        this.value = value;
    }

    /**
     * Gets the string value of this response type.
     *
     * @return the string value
     */
    public String getValue() {
        return value;
    }

    /**
     * Checks if the given response contains this response type.
     *
     * @param response the response to check
     * @return true if the response contains this type
     */
    public boolean isInResponse(String response) {
        return response.contains(value);
    }

    /**
     * Checks if the given response ends with this response type.
     *
     * @param response the response to check
     * @return true if the response ends with this type
     */
    public boolean isEndOfResponse(String response) {
        return response.endsWith(value);
    }

    /**
     * Checks if the given response starts with this response type.
     *
     * @param response the response to check
     * @return true if the response starts with this type
     */
    public boolean isStartOfResponse(String response) {
        return response.startsWith(value);
    }
}
