package dev.fitko.fitconnect.core.validation.virusscan.deamon;

import java.nio.charset.StandardCharsets;
import lombok.AllArgsConstructor;

/**
 * Represents ClamAV daemon stream commands used for communication with the ClamAV virus scanner.
 *
 * <p>For detailed information on the protocol and commands, see: <a
 * href="https://github.com/Cisco-Talos/clamav/blob/main/docs/man/clamd.8.in">ClamAV Commands</a>
 * and <a href="https://docs.clamav.net/manual/Usage/Scanning.html#clamd">ClamD Documentation</a>
 */
@AllArgsConstructor
public class ClamAVStreamCommand {

    /** Command to initiate a data stream for virus scanning */
    public static final ClamAVStreamCommand IN_STREAM = new ClamAVStreamCommand("zINSTREAM\0");

    /** Command to ping the ClamAV daemon to check availability */
    public static final ClamAVStreamCommand PING = new ClamAVStreamCommand("zPING\0");

    /** Response command indicating ClamAV daemon is available */
    public static final ClamAVStreamCommand PONG = new ClamAVStreamCommand("PONG");

    /** Command to request ClamAV daemon version information */
    public static final ClamAVStreamCommand VERSION = new ClamAVStreamCommand("zVERSION\0");

    /** Command to signal the end of a data stream */
    public static final ClamAVStreamCommand END_STREAM = new ClamAVStreamCommand(new String(new byte[] {0, 0, 0, 0}));

    private String command;

    /**
     * Returns the command as a String.
     *
     * @return the command string
     */
    public String getAsString() {
        return command;
    }

    /**
     * Returns the command as a byte array using UTF-8 encoding.
     *
     * @return the command as UTF-8 encoded bytes
     */
    public byte[] getAsBytes() {
        return command.getBytes(StandardCharsets.UTF_8);
    }
}
