package dev.fitko.fitconnect.core.validation.virusscan.deamon;

import lombok.Builder;
import lombok.Data;

/** Configuration for ClamAV scanner settings. */
@Data
@Builder
public class ClamAVDeamonConfig {

    @Builder.Default
    private String host = "localhost";

    @Builder.Default
    private int port = 3310;

    @Builder.Default
    private int connectionTimeoutMs = 5_000;

    @Builder.Default
    private int socketTimeoutMs = 10_000;

    @Builder.Default
    private int readBufferSize = 8192;

    /** Creates default configuration. */
    public static ClamAVDeamonConfig defaultConfig() {
        return ClamAVDeamonConfig.builder().build();
    }

    /** Creates configuration with custom host and port. */
    public static ClamAVDeamonConfig of(String host, int port) {
        return ClamAVDeamonConfig.builder().host(host).port(port).build();
    }

    public static ClamAVDeamonConfig of(String host, int port, int connectionTimeout, int socketTimeout) {
        return ClamAVDeamonConfig.builder()
                .host(host)
                .port(port)
                .connectionTimeoutMs(connectionTimeout)
                .socketTimeoutMs(socketTimeout)
                .build();
    }
}
