package dev.fitko.fitconnect.core.utils;

public final class Strings {

    private Strings() {}

    /**
     * Tests a given string on null or empty
     *
     * @param s string to test
     * @return true if the string is null OR empty, false if both conditions do not apply
     */
    public static boolean isNullOrEmpty(final String s) {
        return s == null || s.isEmpty();
    }

    /**
     * Tests a given string on not null and not empty
     *
     * @param s string to test
     * @return true if the string is not null AND not empty, false if one
     *     dev.fitko.fitconnect.integrationtests.condition does not apply
     */
    public static boolean isNotNullOrEmpty(final String s) {
        return !isNullOrEmpty(s);
    }

    /**
     * Replace all non-printable control characters like \t, \r, \n and spaces from the given s.
     *
     * @param s string that should be cleaned
     * @return cleaned string without non-printable chars
     */
    public static String cleanNonPrintableChars(final String s) {
        return s.replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "").replaceAll(" ", "");
    }
}
