package dev.fitko.fitconnect.core.utils;

/** Stopwatch to time requests and method calls */
public final class StopWatch {

    private StopWatch() {}

    /**
     * Get current system time in ms.
     *
     * @return system time in ms as long
     */
    public static long start() {
        return System.currentTimeMillis();
    }

    /**
     * Formats end time based on start time (end - start) in a readable format (e.g. sec:ms)
     *
     * @param startTime start time of the measured call
     * @return formatted elapsed time since start
     */
    public static String stop(final long startTime) {
        return Formatter.formatMillis(stopMeasurement(startTime));
    }

    private static long stopMeasurement(final long startTime) {
        return System.currentTimeMillis() - startTime;
    }
}
