package dev.fitko.fitconnect.core.utils;

import java.util.function.Supplier;

public final class Preconditions {

    private Preconditions() {}

    /**
     * Throws a supplied (runtime) exception if the expression evaluates true
     *
     * @param expression expression to evaluate
     * @param exceptionSupplier supplier for the exception
     */
    public static void checkArgument(
            final boolean expression, final Supplier<? extends RuntimeException> exceptionSupplier) {
        if (expression) {
            throw exceptionSupplier.get();
        }
    }

    /**
     * Throws an IllegalArgumentException exception if the expression evaluates true
     *
     * @param expression expression to evaluate
     * @param message supplier for the exception
     * @throws IllegalArgumentException is the expression evaluates to
     */
    public static void checkArgumentAndThrow(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    /**
     * Throws an IllegalStateException if the argument is null
     *
     * @param argumentName name of the argument to check
     * @param argument argument to check
     */
    public static void checkNotNull(final String argumentName, final Object argument) {
        checkArgument(
                argument == null, () -> new IllegalStateException("Parameter " + argumentName + " must not be null"));
    }
}
