package dev.fitko.fitconnect.core.io;

import static java.lang.System.*;
import static java.util.stream.Collectors.*;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import lombok.Value;

public class ProcessRunner {

    @Value
    public static class Result {
        public int exitCode;
        public String output;
        public String error;
    }

    public static Result runCommand(List<String> command) {

        if (command == null || command.isEmpty()) {
            return new Result(-1, "", "Command list must not be null or empty");
        }

        var builder = new ProcessBuilder(command);
        // we want errors in the general output stream
        builder.redirectErrorStream(false);

        try {
            Process process = builder.start();

            String output = getOutputFromStream(process.getInputStream());
            String error = getOutputFromStream(process.getErrorStream());

            int exitCode = process.waitFor();
            return new Result(exitCode, output, error);

        } catch (IOException | InterruptedException | IllegalArgumentException e) {
            return new Result(-1, "", e.getMessage());
        }
    }

    private static String getOutputFromStream(InputStream stream) {
        return new BufferedReader(new InputStreamReader(stream)).lines().collect(joining(lineSeparator()));
    }
}
