package dev.fitko.fitconnect.core.http.retrylogic;

import static dev.fitko.fitconnect.core.utils.Preconditions.checkArgumentAndThrow;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public final class RandomValue {

    /**
     * Creates random value within the given bounds.
     *
     * @param lowerBound min. of the randomized value (inclusive)
     * @param upperBound max. of the randomized value (inclusive)
     * @return random value within the (inclusive) bounds
     */
    public static int randomIntInRange(int lowerBound, int upperBound) {
        checkArgumentAndThrow(lowerBound >= upperBound, "lowerBound must be greater than upperBound");
        return (int) (Math.random() * ((upperBound - lowerBound) + 1) + lowerBound);
    }
}
