package dev.fitko.fitconnect.core.http.interceptors;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/** Intercepts HTTP calls and logs the request incl. response code and request time. */
public class ApiRequestInterceptor implements Interceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(ApiRequestInterceptor.class);

    @NotNull
    @Override
    public Response intercept(@NotNull final Chain chain) throws IOException {

        final Request request = chain.request();

        long start = System.nanoTime();
        Response response = chain.proceed(request);
        long end = System.nanoTime();

        LOGGER.info(
                "Received response {} for {} on {} in {}ms",
                response.code(),
                request.method(),
                response.request().url(),
                String.format("%.1f", (end - start) / 1e6d));

        return response;
    }
}
